package thelm.packagedauto.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackager;

public class BlockPackager extends BlockBase {

	public static final BlockPackager INSTANCE = new BlockPackager();
	public static final Item ITEM_INSTANCE = new ItemBlock(INSTANCE).setRegistryName("packagedauto:packager");
	public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:packager#normal");

	protected BlockPackager() {
		super(Material.field_151573_f);
		func_149711_c(15F);
		func_149752_b(25F);
		func_149672_a(SoundType.field_185852_e);
		func_149663_c("packagedauto.packager");
		setRegistryName("packagedauto:packager");
		func_149647_a(PackagedAuto.CREATIVE_TAB);
	}

	@Override
	public TileBase func_149915_a(World worldIn, int meta) {
		return new TilePackager();
	}

	@Override
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof TilePackager) {
			((TilePackager)tileentity).updatePowered();
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModels() {
		ModelLoader.setCustomModelResourceLocation(ITEM_INSTANCE, 0, MODEL_LOCATION);
	}
}
