package thelm.packagedauto.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackagerExtension;

public class BlockPackagerExtension extends BlockBase {

	public static final BlockPackagerExtension INSTANCE = new BlockPackagerExtension();
	public static final Item ITEM_INSTANCE = new ItemBlock(INSTANCE).setRegistryName("packagedauto:packager_extension");
	public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:packager_extension#normal");

	protected BlockPackagerExtension() {
		super(Material.field_151573_f);
		func_149711_c(15F);
		func_149752_b(25F);
		func_149672_a(SoundType.field_185852_e);
		func_149663_c("packagedauto.packager_extension");
		setRegistryName("packagedauto:packager_extension");
		func_149647_a(PackagedAuto.CREATIVE_TAB);
	}

	@Override
	public TileBase func_149915_a(World worldIn, int meta) {
		return new TilePackagerExtension();
	}

	@Override
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof TilePackagerExtension) {
			((TilePackagerExtension)tileentity).updatePowered();
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModels() {
		ModelLoader.setCustomModelResourceLocation(ITEM_INSTANCE, 0, MODEL_LOCATION);
	}
}
