package thelm.packagedauto.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.container.ContainerTileBase;
import thelm.packagedauto.slot.SlotFalseCopy;

public abstract class GuiContainerTileBase<CONTAINER extends ContainerTileBase<?>> extends GuiContainer {

	public final CONTAINER container;

	public GuiContainerTileBase(CONTAINER container) {
		super(container);
		this.container = container;
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		func_146276_q_();
		super.func_73863_a(mouseX, mouseY, partialTicks);
		func_191948_b(mouseX, mouseY);
	}

	protected abstract ResourceLocation getBackgroundTexture();

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		field_146297_k.func_110434_K().func_110577_a(getBackgroundTexture());
		if(field_146999_f > 256 || field_147000_g > 256) {
			func_146110_a(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g, 512, 512);
		}
		else {
			func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
		}
	}

	@Override
	protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
		if(mouseButton == 0 &&
				type != ClickType.QUICK_MOVE &&
				field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() &&
				slot instanceof SlotFalseCopy &&
				slot.func_111238_b() &&
				!slot.func_75211_c().func_190926_b()) {
			field_146297_k.func_147108_a(new GuiItemAmountSpecifying(
					this, field_146297_k.field_71439_g.field_71071_by, slot.field_75222_d, slot.func_75211_c(), getItemAmountSpecificationLimit(slot)));
		}
		else {
			super.func_184098_a(slot, slotId, mouseButton, type);
		}
	}

	public int getItemAmountSpecificationLimit(Slot slot) {
		return Math.min(slot.func_75219_a(), slot.func_75211_c().func_77976_d());
	}
}
