package thelm.packagedauto.client.gui;

import java.io.IOException;
import java.util.Arrays;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import thelm.packagedauto.container.ContainerUnpackager;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketChangeBlocking;
import thelm.packagedauto.network.packet.PacketEjectTracker;
import thelm.packagedauto.network.packet.PacketTrackerCount;
import thelm.packagedauto.tile.TileUnpackager.PackageTracker;

public class GuiUnpackager extends GuiContainerTileBase<ContainerUnpackager> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/unpackager.png");

	public GuiUnpackager(ContainerUnpackager container) {
		super(container);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_73866_w_() {
		field_146292_n.clear();
		super.func_73866_w_();
		func_189646_b(new GuiButtonChangeBlocking(0, field_147003_i+98, field_147009_r+16));
		for(int i = 0; i < 10; ++i) {
			func_189646_b(new GuiButtonTracker(i, field_147003_i+115, field_147009_r+16+6*i));
		}
		func_189646_b(new GuiButtonTrackerCount(0, field_147003_i+98, field_147009_r+34));
		func_189646_b(new GuiButtonTrackerCount(1, field_147003_i+106, field_147009_r+34));
	}

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		super.func_146976_a(partialTicks, mouseX, mouseY);
		int scaledEnergy = container.tile.getScaledEnergy(40);
		func_73729_b(field_147003_i+10, field_147009_r+10+40-scaledEnergy, 176, 40-scaledEnergy, 12, scaledEnergy);
		for(int i = 0; i < container.tile.trackers.length; ++i) {
			PackageTracker tracker = container.tile.trackers[i];
			for(int j = 0; j < 9; ++j) {
				if(j < tracker.amount) {
					if(tracker.received.getBoolean(j)) {
						func_73729_b(field_147003_i+115+6*j, field_147009_r+16+6*i, 176, 45, 6, 5);
					}
					else {
						func_73729_b(field_147003_i+115+6*j, field_147009_r+16+6*i, 176, 40, 6, 5);
					}
				}
				else if(i < container.tile.trackerCount) {
					func_73729_b(field_147003_i+115+6*j, field_147009_r+16+6*i, 182, 45, 6, 5);
				}
				else {
					func_73729_b(field_147003_i+115+6*j, field_147009_r+16+6*i, 182, 40, 6, 5);
				}
			}
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		String s = container.inventory.func_145748_c_().func_150260_c();
		field_146289_q.func_78276_b(s, field_146999_f/2 - field_146289_q.func_78256_a(s)/2, 6, 0x404040);
		field_146289_q.func_78276_b(container.playerInventory.func_145748_c_().func_150260_c(), container.getPlayerInvX(), container.getPlayerInvY()-11, 0x404040);
		if(mouseX-field_147003_i >= 10 && mouseY-field_147009_r >= 10 && mouseX-field_147003_i <= 21 && mouseY-field_147009_r <= 49) {
			func_146279_a(container.tile.getEnergyStorage().getEnergyStored()+" / "+container.tile.getEnergyStorage().getMaxEnergyStored()+" FE", mouseX-field_147003_i, mouseY-field_147009_r);
		}
		for(GuiButton guibutton : field_146292_n) {
			if(guibutton.func_146115_a()) {
				guibutton.func_146111_b(mouseX-field_147003_i, mouseY-field_147009_r);
				break;
			}
		}
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		if(button instanceof GuiButtonChangeBlocking) {
			PacketHandler.INSTANCE.sendToServer(new PacketChangeBlocking());
		}
		if(button instanceof GuiButtonTracker) {
			if(func_146272_n()) {
				PacketHandler.INSTANCE.sendToServer(new PacketEjectTracker(button.field_146127_k));
			}
		}
		if(button instanceof GuiButtonTrackerCount) {
			PacketHandler.INSTANCE.sendToServer(new PacketTrackerCount(button.field_146127_k == 0));
		}
	}

	class GuiButtonChangeBlocking extends GuiButton {

		public GuiButtonChangeBlocking(int buttonId, int x, int y) {
			super(buttonId, x, y, 16, 18, "");
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			GlStateManager.func_179131_c(1, 1, 1, 1);
			mc.field_71446_o.func_110577_a(BACKGROUND);
			func_73729_b(field_146128_h+1, field_146129_i+2, 176, container.tile.blocking ? 64 : 50, 14, 14);
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			func_146279_a(I18n.func_74838_a("tile.packagedauto.unpackager.blocking."+container.tile.blocking), mouseX, mouseY);
		}
	}

	class GuiButtonTracker extends GuiButton {

		GuiButtonTracker(int buttonId, int x, int y) {
			super(buttonId, x, y, 54, 5, "");
		}

		@Override
		public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
			if(field_146125_m) {
				field_146123_n = mouseX >= field_146128_h && mouseY >= field_146129_i && mouseX < field_146128_h + field_146120_f && mouseY < field_146129_i + field_146121_g;
			}
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			String line0 = I18n.func_74837_a("tile.packagedauto.unpackager.tracker", field_146127_k);
			String line1 = TextFormatting.GRAY+I18n.func_74838_a("tile.packagedauto.unpackager.tracker.eject");
			func_146283_a(Arrays.asList(line0, line1), mouseX, mouseY);
		}
	}

	class GuiButtonTrackerCount extends GuiButton {

		public GuiButtonTrackerCount(int buttonId, int x, int y) {
			super(buttonId, x, y, 8, 18, "");
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			GlStateManager.func_179131_c(1, 1, 1, 1);
			mc.field_71446_o.func_110577_a(BACKGROUND);
			func_73729_b(field_146128_h+1, field_146129_i+2, field_146127_k == 0 ? 176 : 182, 78, 6, 14);
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			func_146279_a(I18n.func_74838_a("tile.packagedauto.unpackager.tracker."+(field_146127_k == 0 ? "decrease" : "increase")), mouseX, mouseY);
		}
	}
}
