package thelm.packagedauto.crafting;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.item.ItemProxyMarker;

public class RecipeProxyMarkerCloning extends IForgeRegistryEntry.Impl<IRecipe> implements IRecipe {

	public static final RecipeProxyMarkerCloning INSTANCE = new RecipeProxyMarkerCloning();

	protected RecipeProxyMarkerCloning() {
		setRegistryName("packagedauto:proxy_marker_cloning");
	}

	@Override
	public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
		DirectionalGlobalPos template = null;
		int count = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ItemProxyMarker.INSTANCE) {
					if(template == null) {
						DirectionalGlobalPos globalPos = ItemProxyMarker.INSTANCE.getDirectionalGlobalPos(stack);
						if(globalPos != null) {
							template = globalPos;
						}
					}
					++count;
				}
				else {
					return false;
				}
			}
		}
		return template != null && count > 0;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv) {
		DirectionalGlobalPos template = null;
		boolean clearing = false;
		int count = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ItemProxyMarker.INSTANCE) {
					DirectionalGlobalPos globalPos = ItemProxyMarker.INSTANCE.getDirectionalGlobalPos(stack);
					if(globalPos != null) {
						if(template == null) {
							template = globalPos;
						}
						else {
							clearing = true;
						}
					}
					++count;
				}
				else {
					return ItemStack.field_190927_a;
				}
			}
		}
		if(template != null && count > 0) {
			ItemStack result = new ItemStack(ItemProxyMarker.INSTANCE, count);
			if(!clearing && count > 1) {
				ItemProxyMarker.INSTANCE.setDirectionalGlobalPos(result, template);
			}
			return result;
		}
		else {
			return ItemStack.field_190927_a;
		}
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return true;
	}

	@Override
	public ItemStack func_77571_b() {
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean func_192399_d() {
		return true;
	}
}
