package thelm.packagedauto.item;

import java.util.List;

import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IMarkerItem;
import thelm.packagedauto.client.IModelRegister;

public abstract class ItemMarker extends Item implements IMarkerItem, IModelRegister {

	@Override
	public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
		if(!world.field_72995_K && !player.func_70093_af()) {
			ItemStack stack = player.func_184586_b(hand);
			if(getDirectionalGlobalPos(stack) != null) {
				return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
			}
			int dim = world.field_73011_w.getDimension();
			DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dim, pos, side);
			if(stack.func_190916_E() > 1) {
				ItemStack stack1 = stack.func_77979_a(1);
				setDirectionalGlobalPos(stack1, globalPos);
				if(!player.field_71071_by.func_70441_a(stack1)) {
					EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack1);
					item.func_145799_b(player.func_70005_c_());
					world.func_72838_d(item);
				}
			}
			else {
				setDirectionalGlobalPos(stack, globalPos);
			}
			return EnumActionResult.SUCCESS;
		}
		return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		if(!worldIn.field_72995_K && playerIn.func_70093_af() && isBound(playerIn.func_184586_b(handIn))) {
			ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
			setDirectionalGlobalPos(stack, null);
			return new ActionResult<>(EnumActionResult.SUCCESS, stack);
		}
		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		DirectionalGlobalPos pos = getDirectionalGlobalPos(stack);
		if(pos != null) {
			tooltip.add(I18n.func_74837_a("misc.packagedauto.dimension", pos.dimension()));
			String posString = "["+pos.x()+", "+pos.y()+", "+pos.z()+"]";
			tooltip.add(I18n.func_74837_a("misc.packagedauto.position", posString));
			String dirString = I18n.func_74838_a("misc.packagedauto."+pos.direction().func_176610_l());
			tooltip.add(I18n.func_74837_a("misc.packagedauto.direction", dirString));
		}
		super.func_77624_a(stack, worldIn, tooltip, flagIn);
	}

	@Override
	public DirectionalGlobalPos getDirectionalGlobalPos(ItemStack stack) {
		if(isBound(stack)) {
			NBTTagCompound nbt = stack.func_77978_p();
			int dimension = nbt.func_74762_e("Dimension");
			int[] posArray = nbt.func_74759_k("Position");
			BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
			EnumFacing direction = EnumFacing.func_82600_a(nbt.func_74771_c("Direction"));
			return new DirectionalGlobalPos(dimension, blockPos, direction);
		}
		return null;
	}

	@Override
	public void setDirectionalGlobalPos(ItemStack stack, DirectionalGlobalPos pos) {
		if(pos != null) {
			if(!stack.func_77942_o()) {
				stack.func_77982_d(new NBTTagCompound());
			}
			NBTTagCompound nbt = stack.func_77978_p();
			nbt.func_74768_a("Dimension", pos.dimension());
			nbt.func_74783_a("Position", new int[] {pos.x(), pos.y(), pos.z()});
			nbt.func_74774_a("Direction", (byte)pos.direction().func_176745_a());
		}
		else if(stack.func_77942_o()) {
			NBTTagCompound nbt = stack.func_77978_p();
			nbt.func_82580_o("Dimension");
			nbt.func_82580_o("Position");
			nbt.func_82580_o("Direction");
			if(nbt.func_82582_d()) {
				stack.func_77982_d(null);
			}
		}
	}

	public boolean isBound(ItemStack stack) {
		NBTTagCompound nbt = stack.func_77978_p();
		return nbt != null && nbt.func_74764_b("Dimension") && nbt.func_74764_b("Position") && nbt.func_74764_b("Direction");
	}
}
