package thelm.packagedauto.item;

import java.util.List;

import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.ISettingsClonerItem;
import thelm.packagedauto.api.SettingsClonerData;
import thelm.packagedauto.client.IModelRegister;

public class ItemSettingsCloner extends Item implements ISettingsClonerItem, IModelRegister {

	public static final ItemSettingsCloner INSTANCE = new ItemSettingsCloner();
	public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:settings_cloner#inventory");
	public static final ModelResourceLocation MODEL_LOCATION_FILLED = new ModelResourceLocation("packagedauto:settings_cloner_filled#inventory");
	public static final Style ERROR_STYLE = new Style().func_150238_a(TextFormatting.RED);

	protected ItemSettingsCloner() {
		func_77655_b("packagedauto.settings_cloner");
		setRegistryName("packagedauto:settings_cloner");
		func_77637_a(PackagedAuto.CREATIVE_TAB);
		func_77625_d(1);
	}

	@Override
	public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
		TileEntity tile = world.func_175625_s(pos);
		if(tile instanceof ISettingsCloneable) {
			ItemStack stack = player.func_184586_b(hand);
			ISettingsCloneable settable = (ISettingsCloneable)tile;
			String configName = settable.getConfigTypeName();
			if(player.func_70093_af()) {
				if(!world.field_72995_K) {
					NBTTagCompound dataTag = new NBTTagCompound();
					ISettingsCloneable.Result result = settable.saveConfig(dataTag, player);
					if(result.type != ISettingsCloneable.ResultType.FAIL) {
						if(!stack.func_77942_o()) {
							stack.func_77982_d(new NBTTagCompound());
						}
						NBTTagCompound tag = stack.func_77978_p();
						tag.func_74778_a("Type", configName);
						tag.func_74782_a("Data", dataTag);
						tag.func_74768_a("Dimension", world.field_73011_w.getDimension());
						tag.func_74783_a("Position", new int[] {pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
						player.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.saved"));
					}
					else {
						player.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.not_saved", result.message).func_150255_a(ERROR_STYLE));
					}
				}
				return EnumActionResult.SUCCESS;
			}
			SettingsClonerData data = getData(stack);
			if(data != null) {
				if(!world.field_72995_K) {
					if(configName.equals(data.type())) {
						ISettingsCloneable.Result result = settable.loadConfig(data.data(), player);
						switch(result.type) {
						case SUCCESS:
							player.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.loaded"));
							break;
						case PARTIAL:
							player.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.partial_loaded", result.message));
							break;
						case FAIL:
							player.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.not_loaded", result.message).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
							break;
						}
					}
					else {
						ITextComponent errorMessage = new TextComponentTranslation("item.packagedauto.settings_cloner.incompatible");
						player.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.not_loaded", errorMessage).func_150255_a(ERROR_STYLE));
					}
				}
				return EnumActionResult.SUCCESS;
			}
		}
		return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		if(!worldIn.field_72995_K && playerIn.func_70093_af() && hasData(playerIn.func_184586_b(handIn))) {
			ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
			NBTTagCompound nbt = stack.func_77978_p();
			nbt.func_82580_o("Type");
			nbt.func_82580_o("Data");
			nbt.func_82580_o("Dimension");
			nbt.func_82580_o("Position");
			if(nbt.func_82582_d()) {
				stack.func_77982_d(null);
			}
			playerIn.func_145747_a(new TextComponentTranslation("item.packagedauto.settings_cloner.cleared"));
			return new ActionResult<>(EnumActionResult.SUCCESS, stack);
		}
		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		SettingsClonerData data = getData(stack);
		if(data != null) {
			String typeString = I18n.func_74838_a(data.type());
			tooltip.add(I18n.func_74837_a("item.packagedauto.settings_cloner.contents", typeString));
			tooltip.add(I18n.func_74837_a("misc.packagedauto.dimension", data.dimension()));
			String posString = "["+data.x()+", "+data.y()+", "+data.z()+"]";
			tooltip.add(I18n.func_74837_a("misc.packagedauto.position", posString));
		}
		super.func_77624_a(stack, worldIn, tooltip, flagIn);
	}

	@Override
	public SettingsClonerData getData(ItemStack stack) {
		if(hasData(stack)) {
			NBTTagCompound nbt = stack.func_77978_p();
			String type = nbt.func_74779_i("Type");
			NBTTagCompound data = nbt.func_74775_l("Data");
			int dimension = nbt.func_74762_e("Dimension");
			int[] posArray = nbt.func_74759_k("Position");
			BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
			return new SettingsClonerData(type, data, dimension, blockPos);
		}
		return null;
	}

	public boolean hasData(ItemStack stack) {
		NBTTagCompound nbt = stack.func_77978_p();
		return nbt != null && nbt.func_74764_b("Type") && nbt.func_74764_b("Data") && nbt.func_74764_b("Dimension") && nbt.func_74764_b("Position");
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModels() {
		ModelLoader.setCustomMeshDefinition(this, stack->hasData(stack) ? MODEL_LOCATION_FILLED : MODEL_LOCATION);
		ModelBakery.registerItemVariants(this, MODEL_LOCATION, MODEL_LOCATION_FILLED);
	}
}
