package thelm.packagedauto.tile;

import java.util.UUID;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.client.gui.IGuiProvider;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.InventoryTileBase;

public abstract class TileBase extends TileEntity implements IWorldNameable, IGuiProvider {

	protected InventoryTileBase inventory = new InventoryTileBase(this, 0);
	protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
	public String customName = "";
	protected UUID ownerUUID = null;
	@Deprecated
	protected int placerID = -1;

	public InventoryTileBase getInventory() {
		return inventory;
	}

	public void setInventory(InventoryTileBase inventory) {
		this.inventory = inventory;
	}

	public EnergyStorage getEnergyStorage() {
		return energyStorage;
	}

	public void setEnergyStorage(EnergyStorage energyStorage) {
		this.energyStorage = energyStorage;
	}

	public void setOwner(EntityPlayer owner) {
		ownerUUID = owner.func_110124_au();
	}

	public UUID getOwnerUUID() {
		return ownerUUID;
	}

	protected abstract String getLocalizedName();

	@Override
	public String func_70005_c_() {
		return customName.isEmpty() ? getLocalizedName() : customName;
	}

	@Override
	public ITextComponent func_145748_c_() {
		return new TextComponentString(func_70005_c_());
	}

	@Override
	public boolean func_145818_k_() {
		return !customName.isEmpty();
	}

	public void setCustomName(String name) {
		if(!name.isEmpty()) {
			customName = name;
		}
	}

	public int getComparatorSignal() {
		return ItemHandlerHelper.calcRedstoneFromInventory(inventory.getWrapperForDirection(null));
	}

	@Override
	public void func_145839_a(NBTTagCompound nbt) {
		super.func_145839_a(nbt);
		ownerUUID = null;
		if(nbt.func_186855_b("OwnerUUID")) {
			ownerUUID = nbt.func_186857_a("OwnerUUID");
		}
		readSyncNBT(nbt);
		inventory.readFromNBT(nbt);
		energyStorage.readFromNBT(nbt);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
		super.func_189515_b(nbt);
		if(ownerUUID != null) {
			nbt.func_186854_a("OwnerUUID", ownerUUID);
		}
		writeSyncNBT(nbt);
		inventory.writeToNBT(nbt);
		energyStorage.writeToNBT(nbt);
		return nbt;
	}

	public void readSyncNBT(NBTTagCompound nbt) {
		if(nbt.func_74764_b("Name")) {
			customName = nbt.func_74779_i("Name");
		}
	}

	public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
		if(!customName.isEmpty()) {
			nbt.func_74778_a("Name", customName);
		}
		return nbt;
	}

	@Override
	public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
		readSyncNBT(pkt.func_148857_g());
	}

	@Override
	public SPacketUpdateTileEntity func_189518_D_() {
		return new SPacketUpdateTileEntity(field_174879_c, -10, func_189517_E_());
	}

	@Override
	public void handleUpdateTag(NBTTagCompound tag) {
		readSyncNBT(tag);
	}

	@Override
	public NBTTagCompound func_189517_E_() {
		NBTTagCompound nbt = super.func_189517_E_();
		nbt.func_82580_o("ForgeData");
		nbt.func_82580_o("ForgeCaps");
		writeSyncNBT(nbt);
		return nbt;
	}

	public void syncTile(boolean rerender) {
		if(field_145850_b != null && field_145850_b.func_175667_e(field_174879_c)) {
			IBlockState state = field_145850_b.func_180495_p(field_174879_c);
			field_145850_b.func_184138_a(field_174879_c, state, state, 2 + (rerender ? 4 : 0));
		}
	}

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing from) {
		return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ||
				capability == CapabilityEnergy.ENERGY && energyStorage.getMaxEnergyStored() > 0 ||
				super.hasCapability(capability, from);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
		if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
			return (T)inventory.getWrapperForDirection(facing);
		}
		else if(capability == CapabilityEnergy.ENERGY && energyStorage.getMaxEnergyStored() > 0) {
			return (T)energyStorage;
		}
		return super.getCapability(capability, facing);
	}
}
