package thelm.packagedauto.tile;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.client.gui.GuiCraftingProxy;
import thelm.packagedauto.container.ContainerCraftingProxy;
import thelm.packagedauto.integration.appeng.networking.HostHelperTileCraftingProxy;
import thelm.packagedauto.inventory.InventoryCraftingProxy;
import thelm.packagedauto.item.ItemProxyMarker;
import thelm.packagedauto.network.packet.PacketBeam;
import thelm.packagedauto.network.packet.PacketDirectionalMarker;
import thelm.packagedauto.network.packet.PacketSizedMarker;

@Optional.InterfaceList({
	@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"),
	@Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2"),
})
public class TileCraftingProxy extends TileBase implements ITickable, IPackageCraftingMachine, ISettingsCloneable, IGridHost, IActionHost {

	public static int range = 8;

	public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60, TimeUnit.SECONDS).build();

	public DirectionalGlobalPos target;
	public boolean firstTick = true;

	public TileCraftingProxy() {
		setInventory(new InventoryCraftingProxy(this));
		if(Loader.isModLoaded("appliedenergistics2")) {
			hostHelper = new HostHelperTileCraftingProxy(this);
		}
	}

	@Override
	protected String getLocalizedName() {
		return I18n.func_74838_a("tile.packagedauto.crafting_proxy.name");
	}

	@Override
	public String getConfigTypeName() {
		return "tile.packagedauto.crafting_proxy.name";
	}

	@Override
	public void func_73660_a() {
		if(firstTick) {
			firstTick = false;
			if(!field_145850_b.field_72995_K && hostHelper != null) {
				hostHelper.isActive();
			}
		}
	}

	@Override
	public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
		if(!isBusy()) {
			IPackageCraftingMachine machine = (IPackageCraftingMachine)field_145850_b.func_175625_s(target.blockPos());
			if(machine.acceptPackage(recipeInfo, stacks, target.direction())) {
				EnumFacing dir = target.direction();
				Vec3d source = new Vec3d(field_174879_c).func_72441_c(0.5, 0.5, 0.5);
				Vec3d delta = new Vec3d(target.blockPos().func_177973_b(field_174879_c)).func_178787_e(new Vec3d(dir.func_176730_m()).func_186678_a(0.5));
				PacketBeam.sendBeams(source, Collections.singletonList(delta), 0xFF7F00, 6, true, field_145850_b.field_73011_w.getDimension(), 32);
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		if(target == null) {
			return true;
		}
		BlockPos pos = target.blockPos();
		if(!field_145850_b.func_175667_e(pos)) {
			return true;
		}
		TileEntity tile = field_145850_b.func_175625_s(pos);
		if(tile != null &&
				!(tile instanceof TileCraftingProxy) &&
				tile instanceof IPackageCraftingMachine) {
			return ((IPackageCraftingMachine)tile).isBusy();
		}
		return true;
	}

	public void sendPreview(EntityPlayerMP player) {
		long currentTime = field_145850_b.func_82737_E();
		Long cachedTime = previewTimes.getIfPresent(player.func_110124_au());
		if(cachedTime == null || currentTime-cachedTime > 180) {
			previewTimes.put(player.func_110124_au(), currentTime);
			if(target != null) {
				EnumFacing dir = target.direction();
				Vec3d source = new Vec3d(field_174879_c).func_72441_c(0.5, 0.5, 0.5);
				Vec3d delta = new Vec3d(target.blockPos().func_177973_b(field_174879_c)).func_178787_e(new Vec3d(dir.func_176730_m()).func_186678_a(0.5));
				PacketDirectionalMarker.sendDirectionalMarkers(player, Collections.singletonList(target), 0xFFFF00, 200);
				PacketBeam.sendBeams(player, source, Collections.singletonList(delta), 0xFFFF00, 200, false);
			}
			Vec3d lowerCorner = new Vec3d(field_174879_c).func_178786_a(range, range, range);
			Vec3d size = new Vec3d(range*2+1, range*2+1, range*2+1);
			PacketSizedMarker.sendSizedMarker(player, lowerCorner, size, 0xFF7F00, 200);
		}
	}

	public HostHelperTileCraftingProxy hostHelper;

	@Override
	public void func_145843_s() {
		super.func_145843_s();
		if(hostHelper != null) {
			hostHelper.invalidate();
		}
	}

	@Override
	public void onChunkUnload() {
		super.onChunkUnload();
		if(hostHelper != null) {
			hostHelper.invalidate();
		}
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public IGridNode getGridNode(AEPartLocation dir) {
		return getActionableNode();
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public AECableType getCableConnectionType(AEPartLocation dir) {
		return AECableType.SMART;
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public void securityBreak() {
		field_145850_b.func_175655_b(field_174879_c, true);
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public IGridNode getActionableNode() {
		return hostHelper.getNode();
	}

	@Override
	public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
		if(!nbt.func_74764_b("Target")) {
			return ISettingsCloneable.Result.fail(new TextComponentTranslation("item.packagedauto.settings_cloner.invalid"));
		}
		int availableCount = 0;
		InventoryPlayer playerInventory = player.field_71071_by;
		if(!inventory.func_70301_a(0).func_190926_b()) {
			if(inventory.func_70301_a(0).func_77973_b() == ItemProxyMarker.INSTANCE) {
				availableCount += inventory.func_70301_a(0).func_190916_E();
			}
			else {
				return ISettingsCloneable.Result.fail(new TextComponentTranslation("tile.packagedauto.crafting_proxy.non_marker_present"));
			}
		}
		f:if(availableCount < 1) {
			for(int i = 0; i < playerInventory.func_70302_i_(); ++i) {
				ItemStack stack = playerInventory.func_70301_a(i);
				if(!stack.func_190926_b() && stack.func_77973_b() == ItemProxyMarker.INSTANCE && !stack.func_77942_o()) {
					availableCount += stack.func_190916_E();
				}
				if(availableCount >= 1) {
					break f;
				}
			}
			return ISettingsCloneable.Result.fail(new TextComponentTranslation("tile.packagedauto.crafting_proxy.no_markers"));
		}
		int removedCount = inventory.func_70301_a(0).func_190916_E();
		inventory.func_70299_a(0, ItemStack.field_190927_a);
		if(removedCount < 1) {
			for(int i = 0; i < playerInventory.func_70302_i_(); ++i) {
				ItemStack stack = playerInventory.func_70301_a(i);
				if(!stack.func_190926_b() && stack.func_77973_b() == ItemProxyMarker.INSTANCE && !stack.func_77942_o()) {
					removedCount += stack.func_77979_a(1).func_190916_E();
				}
				if(removedCount >= 1) {
					break;
				}
			}
		}
		if(removedCount > 1) {
			ItemStack stack = new ItemStack(ItemProxyMarker.INSTANCE, removedCount-1);
			if(!playerInventory.func_70441_a(stack)) {
				EntityItem item = new EntityItem(field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
				item.func_145799_b(player.func_70005_c_());
				field_145850_b.func_72838_d(item);
			}
		}
		NBTTagCompound targetTag = nbt.func_74775_l("Target");
		int dimension = targetTag.func_74762_e("Dimension");
		int[] posArray = targetTag.func_74759_k("Position");
		BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
		EnumFacing direction = EnumFacing.func_82600_a(targetTag.func_74771_c("Direction"));
		DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dimension, blockPos, direction);
		ItemStack stack = new ItemStack(ItemProxyMarker.INSTANCE);
		ItemProxyMarker.INSTANCE.setDirectionalGlobalPos(stack, globalPos);
		inventory.func_70299_a(0, stack);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
		if(target == null) {
			return ISettingsCloneable.Result.fail(new TextComponentTranslation("tile.packagedauto.crafting_proxy.empty"));
		}
		NBTTagCompound targetTag = new NBTTagCompound();
		targetTag.func_74768_a("Dimension", target.dimension());
		targetTag.func_74783_a("Position", new int[] {target.x(), target.y(), target.z()});
		targetTag.func_74774_a("Direction", (byte)target.direction().func_176745_a());
		nbt.func_74782_a("Target", targetTag);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void func_145839_a(NBTTagCompound nbt) {
		if(hostHelper != null) {
			hostHelper.readFromNBT(nbt);
		}
		super.func_145839_a(nbt);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
		super.func_189515_b(nbt);
		if(hostHelper != null) {
			hostHelper.writeToNBT(nbt);
		}
		return nbt;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public GuiContainer getClientGuiElement(EntityPlayer player, Object... args) {
		return new GuiCraftingProxy(new ContainerCraftingProxy(player.field_71071_by, this));
	}

	@Override
	public Container getServerGuiElement(EntityPlayer player, Object... args) {
		return new ContainerCraftingProxy(player.field_71071_by, this);
	}
}
