/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.event;

import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedauto.block.CrafterBlock;
import thelm.packagedauto.block.CraftingProxyBlock;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.block.EncoderBlock;
import thelm.packagedauto.block.PackagerBlock;
import thelm.packagedauto.block.PackagerExtensionBlock;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.config.PackagedAutoConfig;
import thelm.packagedauto.container.CrafterContainer;
import thelm.packagedauto.container.CraftingProxyContainer;
import thelm.packagedauto.container.DistributorContainer;
import thelm.packagedauto.container.EncoderContainer;
import thelm.packagedauto.container.PackagerContainer;
import thelm.packagedauto.container.PackagerExtensionContainer;
import thelm.packagedauto.container.UnpackagerContainer;
import thelm.packagedauto.crafting.DistributorMarkerCloningRecipe;
import thelm.packagedauto.crafting.ProxyMarkerCloningRecipe;
import thelm.packagedauto.crafting.RecipeHolderCloningRecipe;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.item.MiscItem;
import thelm.packagedauto.item.PackageItem;
import thelm.packagedauto.item.ProxyMarkerItem;
import thelm.packagedauto.item.RecipeHolderItem;
import thelm.packagedauto.item.SettingsClonerItem;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.recipe.CraftingPackageRecipeType;
import thelm.packagedauto.recipe.OrderedProcessingPackageRecipeType;
import thelm.packagedauto.recipe.PositionedProcessingPackageRecipeType;
import thelm.packagedauto.recipe.ProcessingPackageRecipeType;
import thelm.packagedauto.tile.CrafterTile;
import thelm.packagedauto.tile.CraftingProxyTile;
import thelm.packagedauto.tile.DistributorTile;
import thelm.packagedauto.tile.EncoderTile;
import thelm.packagedauto.tile.PackagerExtensionTile;
import thelm.packagedauto.tile.PackagerTile;
import thelm.packagedauto.tile.UnpackagerTile;
import thelm.packagedauto.util.ApiImpl;
import thelm.packagedauto.util.MiscHelper;

public class CommonEventHandler {
    public static final CommonEventHandler INSTANCE = new CommonEventHandler();

    public static CommonEventHandler getInstance() {
        return INSTANCE;
    }

    public void onConstruct() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        PackagedAutoConfig.registerConfig();
    }

    @SubscribeEvent
    public void onBlockRegister(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)EncoderBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)PackagerBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)PackagerExtensionBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)UnpackagerBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)DistributorBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)CraftingProxyBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)CrafterBlock.INSTANCE);
    }

    @SubscribeEvent
    public void onItemRegister(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)EncoderBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)PackagerBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)PackagerExtensionBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)UnpackagerBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)DistributorBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)CraftingProxyBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)CrafterBlock.ITEM_INSTANCE);
        registry.register((IForgeRegistryEntry)RecipeHolderItem.INSTANCE);
        registry.register((IForgeRegistryEntry)DistributorMarkerItem.INSTANCE);
        registry.register((IForgeRegistryEntry)ProxyMarkerItem.INSTANCE);
        registry.register((IForgeRegistryEntry)SettingsClonerItem.INSTANCE);
        registry.register((IForgeRegistryEntry)PackageItem.INSTANCE);
        registry.register((IForgeRegistryEntry)MiscItem.PACKAGE_COMPONENT);
        registry.register((IForgeRegistryEntry)MiscItem.ME_PACKAGE_COMPONENT);
    }

    @SubscribeEvent
    public void onTileRegister(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(EncoderTile.TYPE_INSTANCE);
        registry.register(PackagerTile.TYPE_INSTANCE);
        registry.register(PackagerExtensionTile.TYPE_INSTANCE);
        registry.register(UnpackagerTile.TYPE_INSTANCE);
        registry.register(DistributorTile.TYPE_INSTANCE);
        registry.register(CraftingProxyTile.TYPE_INSTANCE);
        registry.register(CrafterTile.TYPE_INSTANCE);
    }

    @SubscribeEvent
    public void onContainerRegister(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(EncoderContainer.TYPE_INSTANCE);
        registry.register(PackagerContainer.TYPE_INSTANCE);
        registry.register(PackagerExtensionContainer.TYPE_INSTANCE);
        registry.register(UnpackagerContainer.TYPE_INSTANCE);
        registry.register(DistributorContainer.TYPE_INSTANCE);
        registry.register(CraftingProxyContainer.TYPE_INSTANCE);
        registry.register(CrafterContainer.TYPE_INSTANCE);
    }

    @SubscribeEvent
    public void onRecipeSerializerRegister(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(RecipeHolderCloningRecipe.SERIALIZER);
        registry.register(DistributorMarkerCloningRecipe.SERIALIZER);
        registry.register(ProxyMarkerCloningRecipe.SERIALIZER);
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        ApiImpl.INSTANCE.registerRecipeType(ProcessingPackageRecipeType.INSTANCE);
        ApiImpl.INSTANCE.registerRecipeType(OrderedProcessingPackageRecipeType.INSTANCE);
        ApiImpl.INSTANCE.registerRecipeType(PositionedProcessingPackageRecipeType.INSTANCE);
        ApiImpl.INSTANCE.registerRecipeType(CraftingPackageRecipeType.INSTANCE);
        PacketHandler.registerPackets();
    }

    @SubscribeEvent
    public void onModConfig(ModConfig.ModConfigEvent event) {
        switch (event.getConfig().getType()) {
            case SERVER: {
                PackagedAutoConfig.reloadServerConfig();
                break;
            }
        }
    }

    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        MiscHelper.INSTANCE.setServer(event.getServer());
    }
}

