/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.networking;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import thelm.packagedauto.tile.BaseTile;

public class BaseGridBlock<T extends BaseTile>
implements IGridBlock {
    public final T tile;
    public double idlePower = 1.0;
    public final EnumSet<GridFlags> flags = EnumSet.of(GridFlags.REQUIRE_CHANNEL);

    public BaseGridBlock(T tile) {
        this.tile = tile;
    }

    public double getIdlePowerUsage() {
        return this.idlePower;
    }

    public EnumSet<GridFlags> getFlags() {
        return this.flags;
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile);
    }

    public AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    public void onGridNotification(GridNotification gridNotification) {
    }

    public EnumSet<Direction> getConnectableSides() {
        return EnumSet.allOf(Direction.class);
    }

    public IGridHost getMachine() {
        return (IGridHost)this.tile;
    }

    public void gridChanged() {
    }

    public ItemStack getMachineRepresentation() {
        if (this.tile != null) {
            return new ItemStack((IItemProvider)this.tile.func_195044_w().func_177230_c(), 1);
        }
        return ItemStack.field_190927_a;
    }
}

