/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.tile;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import thelm.packagedauto.integration.appeng.networking.BaseGridBlock;
import thelm.packagedauto.tile.CrafterTile;

public class AECrafterTile
extends CrafterTile
implements IGridHost,
IActionHost {
    public boolean firstTick = true;
    public BaseGridBlock<AECrafterTile> gridBlock = new BaseGridBlock<AECrafterTile>(this);
    public IActionSource source = new MachineSource((IActionHost)this);
    public IGridNode gridNode;

    public AECrafterTile() {
        this.gridBlock.flags.remove(GridFlags.REQUIRE_CHANNEL);
    }

    @Override
    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                this.getActionableNode().updateState();
            }
        }
        super.func_73660_a();
        if (drawMEEnergy && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    public IGridNode getActionableNode() {
        if (this.gridNode == null && !Platform.isClient()) {
            IAppEngApi api = Api.instance();
            this.gridNode = api.grid().createGridNode(this.gridBlock);
            if (this.ownerUUID != null) {
                this.gridNode.setPlayerID(api.registries().players().getID(new GameProfile(this.ownerUUID, "[UNKNOWN]")));
            }
        }
        return this.gridNode;
    }

    @Override
    protected void ejectItems() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            IItemStorageChannel storageChannel = (IItemStorageChannel)Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
            IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
            int endIndex = this.isWorking ? 9 : 0;
            for (int i = 9; i >= endIndex; --i) {
                ItemStack is = this.itemHandler.getStackInSlot(i);
                if (is.func_190926_b()) continue;
                IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)is);
                IAEItemStack rem = (IAEItemStack)Api.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, this.source, Actionable.MODULATE);
                if (rem == null || rem.getStackSize() == 0L) {
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    continue;
                }
                if (rem.getStackSize() >= stack.getStackSize()) continue;
                this.itemHandler.setStackInSlot(i, rem.createItemStack());
            }
        } else {
            super.ejectItems();
        }
    }

    protected void chargeMEEnergy() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyGrid.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyGrid.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        if (nbt.func_74764_b("Node")) {
            this.getActionableNode().loadFromNBT("Node", nbt);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT("Node", nbt);
        }
        return nbt;
    }
}

