/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.tile;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.integration.appeng.networking.BaseGridBlock;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.tile.AEPackagerExtensionTile;
import thelm.packagedauto.tile.PackagerTile;

public class AEPackagerTile
extends PackagerTile
implements IGridHost,
IActionHost,
ICraftingProvider {
    public BaseGridBlock<AEPackagerTile> gridBlock = new BaseGridBlock<AEPackagerTile>(this);
    public IActionSource source = new MachineSource((IActionHost)this);
    public IGridNode gridNode;

    @Override
    public void func_73660_a() {
        if (this.firstTick && !this.field_145850_b.field_72995_K) {
            this.getActionableNode().updateState();
        }
        super.func_73660_a();
        if (drawMEEnergy && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    public IGridNode getActionableNode() {
        if (this.gridNode == null && !Platform.isClient()) {
            IAppEngApi api = Api.instance();
            this.gridNode = api.grid().createGridNode(this.gridBlock);
            if (this.ownerUUID != null) {
                this.gridNode.setPlayerID(api.registries().players().getID(new GameProfile(this.ownerUUID, "[UNKNOWN]")));
            }
        }
        return this.gridNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pushPattern(ICraftingPatternDetails patternDetails, CraftingInventory table) {
        ItemStack slotStack;
        ItemStack outputStack;
        IPackagePattern pattern;
        if (!this.getActionableNode().isActive()) return false;
        if (patternDetails instanceof PackageCraftingPatternDetails) {
            PackageCraftingPatternDetails details = (PackageCraftingPatternDetails)patternDetails;
            pattern = details.pattern;
            outputStack = pattern.getOutput();
        } else {
            outputStack = ((IAEItemStack)patternDetails.getOutputs().get(0)).createItemStack();
            if (!(outputStack.func_77973_b() instanceof IPackageItem)) return false;
            IPackageItem packageItem = (IPackageItem)outputStack.func_77973_b();
            IPackageRecipeInfo recipe = packageItem.getRecipeInfo(outputStack);
            int index = packageItem.getIndex(outputStack);
            if (recipe == null || !recipe.validPatternIndex(index)) return false;
            pattern = recipe.getPatterns().get(index);
        }
        if (this.canPushPattern() && ((slotStack = this.itemHandler.getStackInSlot(9)).func_190926_b() || slotStack.func_77969_a(outputStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + 1 <= outputStack.func_77976_d())) {
            this.currentPattern = pattern;
            this.lockPattern = true;
            for (int i = 0; i < table.func_70302_i_() && i < 9; ++i) {
                this.itemHandler.setStackInSlot(i, table.func_70301_a(i).func_77946_l());
            }
            return true;
        }
        for (BlockPos posP : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            ItemStack slotStack2;
            TileEntity te = this.field_145850_b.func_175625_s(posP);
            if (!(te instanceof AEPackagerExtensionTile)) continue;
            AEPackagerExtensionTile extension = (AEPackagerExtensionTile)te;
            if (extension.packager != this || !extension.getActionableNode().isActive() || this.getActionableNode().getGrid() != extension.getActionableNode().getGrid() || !extension.canPushPattern() || !(slotStack2 = extension.getItemHandler().getStackInSlot(9)).func_190926_b() && (!slotStack2.func_77969_a(outputStack) || !ItemStack.func_77970_a((ItemStack)slotStack2, (ItemStack)outputStack) || slotStack2.func_190916_E() + 1 > outputStack.func_77976_d())) continue;
            extension.currentPattern = pattern;
            extension.lockPattern = true;
            for (int i = 0; i < table.func_70302_i_() && i < 9; ++i) {
                extension.getItemHandler().setStackInSlot(i, table.func_70301_a(i).func_77946_l());
            }
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        if (this.canPushPattern()) {
            return false;
        }
        for (BlockPos posP : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            TileEntity te = this.field_145850_b.func_175625_s(posP);
            if (!(te instanceof AEPackagerExtensionTile)) continue;
            AEPackagerExtensionTile extension = (AEPackagerExtensionTile)te;
            if (extension.packager != this || this.getActionableNode().getGrid() != extension.getActionableNode().getGrid() || !extension.canPushPattern()) continue;
            return false;
        }
        return true;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getActionableNode().isActive()) {
            for (IPackagePattern pattern : this.patternList) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)new PackageCraftingPatternDetails(pattern).toAEInternal(this.field_145850_b));
            }
        }
    }

    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged event) {
        this.postPatternChange();
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange event) {
        this.postPatternChange();
    }

    @Override
    protected void ejectItem() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            IItemStorageChannel storageChannel = (IItemStorageChannel)Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
            IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
            IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)this.itemHandler.getStackInSlot(9));
            IAEItemStack rem = (IAEItemStack)Api.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, this.source, Actionable.MODULATE);
            if (rem == null || rem.getStackSize() == 0L) {
                this.itemHandler.setStackInSlot(9, ItemStack.field_190927_a);
            } else if (rem.getStackSize() < stack.getStackSize()) {
                this.itemHandler.setStackInSlot(9, rem.createItemStack());
            }
        } else {
            super.ejectItem();
        }
    }

    @Override
    public void postPatternChange() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getActionableNode()));
        }
    }

    protected void chargeMEEnergy() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyGrid.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyGrid.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        if (nbt.func_74764_b("Node")) {
            this.getActionableNode().loadFromNBT("Node", nbt);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT("Node", nbt);
        }
        return nbt;
    }
}

