/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.integration.jei.category.PackageContentsCategory;
import thelm.packagedauto.integration.jei.category.PackageProcessingCategory;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.integration.jei.category.PackagingCategory;

public class PackageManagerPlugin
implements IRecipeManagerPlugin {
    public <V> List<ResourceLocation> getRecipeCategoryUids(IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            if (stack.func_77973_b() instanceof IPackageItem) {
                switch (focus.getMode()) {
                    case INPUT: {
                        return ImmutableList.of((Object)PackageRecipeCategory.UID, (Object)PackageProcessingCategory.UID, (Object)PackageContentsCategory.UID);
                    }
                    case OUTPUT: {
                        return ImmutableList.of((Object)PackageRecipeCategory.UID, (Object)PackagingCategory.UID);
                    }
                }
            }
            if (stack.func_77973_b() instanceof IPackageRecipeListItem) {
                switch (focus.getMode()) {
                    case INPUT: {
                        return ImmutableList.of((Object)PackageRecipeCategory.UID, (Object)PackageProcessingCategory.UID);
                    }
                    case OUTPUT: {
                        return ImmutableList.of((Object)PackageRecipeCategory.UID);
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            ResourceLocation uid = recipeCategory.getUid();
            ItemStack stack = (ItemStack)focus.getValue();
            if (stack.func_77973_b() instanceof IPackageItem) {
                IPackageItem packageItem = (IPackageItem)stack.func_77973_b();
                IPackageRecipeInfo recipe = packageItem.getRecipeInfo(stack);
                int index = packageItem.getIndex(stack);
                if (recipe != null && recipe.validPatternIndex(index)) {
                    if (PackageRecipeCategory.UID.equals((Object)uid) || PackageProcessingCategory.UID.equals((Object)uid)) {
                        return Collections.singletonList(recipe);
                    }
                    if (PackagingCategory.UID.equals((Object)uid) || PackageContentsCategory.UID.equals((Object)uid)) {
                        return Collections.singletonList(recipe.getPatterns().get(index));
                    }
                }
            }
            if (stack.func_77973_b() instanceof IPackageRecipeListItem) {
                List<IPackageRecipeInfo> recipeList = ((IPackageRecipeListItem)stack.func_77973_b()).getRecipeList(stack).getRecipeList();
                if (PackageRecipeCategory.UID.equals((Object)uid) || PackageProcessingCategory.UID.equals((Object)uid)) {
                    return recipeList;
                }
            }
        }
        return Collections.emptyList();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }
}

