/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import com.google.common.collect.Maps;
import java.util.Map;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import thelm.packagedauto.api.IGuiIngredientWrapper;
import thelm.packagedauto.api.IRecipeLayoutWrapper;
import thelm.packagedauto.integration.jei.GuiIngredientWrapper;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class RecipeLayoutWrapper
implements IRecipeLayoutWrapper {
    private final Object recipe;
    private final IRecipeLayout recipeLayout;

    public RecipeLayoutWrapper(Object recipe, IRecipeLayout recipeLayout) {
        this.recipe = recipe;
        this.recipeLayout = recipeLayout;
    }

    @Override
    public ResourceLocation getCategoryUid() {
        return this.recipeLayout.getRecipeCategory().getUid();
    }

    @Override
    public Class<?> getCategoryRecipeClass() {
        return this.recipeLayout.getRecipeCategory().getRecipeClass();
    }

    @Override
    public Object getRecipe() {
        return this.recipe;
    }

    @Override
    public Map<Integer, IGuiIngredientWrapper<ItemStack>> getItemStackIngredients() {
        return Maps.transformValues((Map)this.recipeLayout.getItemStacks().getGuiIngredients(), GuiIngredientWrapper::new);
    }

    @Override
    public Map<Integer, IGuiIngredientWrapper<FluidStack>> getFluidStackIngredients() {
        return Maps.transformValues((Map)this.recipeLayout.getFluidStacks().getGuiIngredients(), GuiIngredientWrapper::new);
    }

    @Override
    public <V> Map<Integer, IGuiIngredientWrapper<V>> getIngredients(Class<? extends V> ingredientClass) {
        return Maps.transformValues((Map)this.recipeLayout.getIngredientsGroup(PackagedAutoJEIPlugin.jeiRuntime.getIngredientManager().getIngredientType(ingredientClass)).getGuiIngredients(), GuiIngredientWrapper::new);
    }
}

