/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class PackageProcessingCategory
implements IRecipeCategory<IPackageRecipeInfo> {
    public static final ResourceLocation UID = new ResourceLocation("packagedauto:package_processing");
    public static final ITextComponent TITLE = new TranslationTextComponent("jei.category.packagedauto.package_processing");
    private final IDrawable background;
    private final IDrawable icon;

    public PackageProcessingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 108, 0, 140, 64);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)UnpackagerBlock.INSTANCE));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IPackageRecipeInfo> getRecipeClass() {
        return IPackageRecipeInfo.class;
    }

    public ITextComponent getTitleAsTextComponent() {
        return TITLE;
    }

    public String getTitle() {
        return TITLE.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IPackageRecipeInfo recipe, IIngredients ingredients) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, IPackageRecipeInfo recipe, IIngredients ingredients) {
        int index;
        int j;
        int i;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        List<IPackagePattern> patterns = recipe.getPatterns();
        List<ItemStack> outputs = recipe.getOutputs();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                index = i * 3 + j;
                stacks.init(index, true, j * 18, 10 + i * 18);
                if (index >= patterns.size()) continue;
                stacks.set(index, patterns.get(index).getOutput());
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                index = i * 3 + j;
                int slot = 9 + index;
                stacks.init(slot, false, 86 + j * 18, 10 + i * 18);
                if (index >= outputs.size()) continue;
                stacks.set(slot, outputs.get(index));
            }
        }
    }

    public void draw(IPackageRecipeInfo recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String s = recipe.getRecipeType().getDisplayName().getString();
        font.func_238421_b_(matrixStack, s, (float)(this.background.getWidth() / 2 - font.func_78256_a(s) / 2), 0.0f, 0x404040);
    }
}

