/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.block.EncoderBlock;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class PackageRecipeCategory
implements IRecipeCategory<IPackageRecipeInfo> {
    public static final ResourceLocation UID = new ResourceLocation("packagedauto:package_recipe");
    public static final ITextComponent TITLE = new TranslationTextComponent("jei.category.packagedauto.package_recipe");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;

    public PackageRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 0, 0, 162, 208);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)EncoderBlock.INSTANCE));
        this.slotBackground = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 162, 118, 16, 16);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IPackageRecipeInfo> getRecipeClass() {
        return IPackageRecipeInfo.class;
    }

    public ITextComponent getTitleAsTextComponent() {
        return TITLE;
    }

    public String getTitle() {
        return TITLE.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IPackageRecipeInfo recipe, IIngredients ingredients) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, IPackageRecipeInfo recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IPackageRecipeType recipeType = recipe.getRecipeType();
        Int2ObjectMap<ItemStack> map = recipe.getEncoderStacks();
        List<ItemStack> outputs = recipe.getOutputs();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                stacks.init(index, true, j * 18, 10 + i * 18);
                stacks.setBackground(index, (IDrawable)new ColoredSlot(recipeType.getSlotColor(index)));
                if (!map.containsKey(index)) continue;
                stacks.set(index, (ItemStack)map.get(index));
            }
        }
        for (int index = 0; index < 9; ++index) {
            int slot = 81 + index;
            stacks.init(slot, false, index * 18, 190);
            if (index >= outputs.size()) continue;
            stacks.set(slot, outputs.get(index));
        }
    }

    public void draw(IPackageRecipeInfo recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String s = recipe.getRecipeType().getDisplayName().getString();
        font.func_238421_b_(matrixStack, s, (float)(this.background.getWidth() / 2 - font.func_78256_a(s) / 2), 0.0f, 0x404040);
    }

    class ColoredSlot
    implements IDrawable {
        private Vector3i color;

        public ColoredSlot(Vector3i color) {
            this.color = color;
        }

        public int getWidth() {
            return 18;
        }

        public int getHeight() {
            return 18;
        }

        public void draw(MatrixStack matrixStack, int xOffset, int yOffset) {
            RenderSystem.color4f((float)((float)this.color.func_177958_n() / 255.0f), (float)((float)this.color.func_177956_o() / 255.0f), (float)((float)this.color.func_177952_p() / 255.0f), (float)1.0f);
            PackageRecipeCategory.this.slotBackground.draw(matrixStack, xOffset + 1, yOffset + 1);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

