/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.recipe.ProcessingPackageRecipeType;
import thelm.packagedauto.tile.EncoderTile;
import thelm.packagedauto.util.ApiImpl;

public class EncoderPatternItemHandler
extends BaseItemHandler<EncoderTile> {
    public final EncoderTile tile;
    public IPackageRecipeType recipeType;
    public IPackageRecipeInfo recipeInfo;

    public EncoderPatternItemHandler(EncoderTile tile) {
        super(tile, 99);
        this.tile = tile;
        this.validateRecipeType();
    }

    @Override
    public void onContentsChanged(int slot) {
        this.updateRecipeInfo(true);
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.recipeType = ApiImpl.INSTANCE.getRecipeType(new ResourceLocation(nbt.func_74779_i("RecipeType")));
        this.validateRecipeType();
        this.updateRecipeInfo(false);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        super.write(nbt);
        this.validateRecipeType();
        nbt.func_74778_a("RecipeType", this.recipeType.getName().toString());
        return nbt;
    }

    public boolean isItemValid(int index, ItemStack stack) {
        this.validateRecipeType();
        if (index < 81 || this.recipeType.canSetOutput() && index < 90) {
            return this.recipeType.getEnabledSlots().contains(index);
        }
        return false;
    }

    public void validateRecipeType() {
        if (this.recipeType == null) {
            this.recipeType = ProcessingPackageRecipeType.INSTANCE;
        }
    }

    public void updateRecipeInfo(boolean mark) {
        this.validateRecipeType();
        if (!this.tile.func_145830_o()) {
            return;
        }
        IPackageRecipeInfo info = this.recipeType.getNewRecipeInfo();
        info.generateFromStacks(this.stacks.subList(0, 81), this.recipeType.canSetOutput() ? this.stacks.subList(81, 90) : Collections.emptyList(), this.tile.func_145831_w());
        if (info.isValid()) {
            if (this.recipeInfo == null || !this.recipeInfo.equals(info)) {
                this.recipeInfo = info;
                if (!this.recipeType.canSetOutput()) {
                    for (int i = 81; i < 90; ++i) {
                        this.stacks.set(i, (Object)ItemStack.field_190927_a);
                    }
                    List<ItemStack> outputs = info.getOutputs();
                    int size = outputs.size();
                    int startIndex = 81;
                    switch (size) {
                        case 1: {
                            ++startIndex;
                        }
                        case 2: 
                        case 3: {
                            startIndex += 3;
                        }
                    }
                    for (int i = 0; i < size; ++i) {
                        this.stacks.set(startIndex + i, (Object)outputs.get(i).func_77946_l());
                    }
                }
                for (int i = 90; i < 99; ++i) {
                    this.stacks.set(i, (Object)ItemStack.field_190927_a);
                }
                List<IPackagePattern> patterns = info.getPatterns();
                for (int i = 0; i < patterns.size() && i < 9; ++i) {
                    this.stacks.set(90 + i, (Object)patterns.get(i).getOutput().func_77946_l());
                }
                if (mark) {
                    this.syncTile(false);
                    this.markDirty();
                }
            }
        } else if (this.recipeInfo != null) {
            int i;
            this.recipeInfo = null;
            if (!this.recipeType.canSetOutput()) {
                for (i = 81; i < 90; ++i) {
                    this.stacks.set(i, (Object)ItemStack.field_190927_a);
                }
            }
            for (i = 90; i < 99; ++i) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
            }
            if (mark) {
                this.syncTile(false);
                this.markDirty();
            }
        }
    }

    public void cycleRecipeType(boolean reverse) {
        this.validateRecipeType();
        do {
            this.recipeType = ApiImpl.INSTANCE.getNextRecipeType(this.recipeType, reverse);
        } while (this.recipeType != null && this.recipeType != ProcessingPackageRecipeType.INSTANCE && EncoderTile.disabledRecipeTypes.contains(this.recipeType.getName().toString()));
        this.validateRecipeType();
        IntSet enabledSlots = this.recipeType.getEnabledSlots();
        for (int i = 0; i < 90; ++i) {
            if (enabledSlots.contains(i)) continue;
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.updateRecipeInfo(true);
        for (EncoderPatternItemHandler patternItemHandler : this.tile.patternItemHandlers) {
            if (patternItemHandler == this) continue;
            patternItemHandler.setRecipeTypeIfEmpty(this.recipeType);
        }
    }

    public void setRecipeTypeIfEmpty(IPackageRecipeType recipeType) {
        if (this.stacks.stream().allMatch(ItemStack::func_190926_b)) {
            this.recipeType = recipeType;
            this.validateRecipeType();
            this.updateRecipeInfo(true);
        }
    }

    public void setRecipe(Int2ObjectMap<ItemStack> map) {
        int i;
        for (i = 0; i < 81; ++i) {
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        if (this.recipeType.canSetOutput()) {
            for (i = 81; i < 90; ++i) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
            }
        }
        if (map != null) {
            for (Int2ObjectMap.Entry entry : map.int2ObjectEntrySet()) {
                this.stacks.set(entry.getIntKey(), entry.getValue());
            }
        }
        this.updateRecipeInfo(true);
    }
}

