/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.UnpackagerItemHandlerWrapper;
import thelm.packagedauto.tile.UnpackagerTile;

public class UnpackagerItemHandler
extends BaseItemHandler<UnpackagerTile> {
    public UnpackagerItemHandler(UnpackagerTile tile) {
        super(tile, 11);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot == 9) {
            this.updateRecipeList();
        } else if (slot != 10) {
            this.clearRejectedIndexes();
        }
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        if (slot == 9) {
            return 1;
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 9: {
                return stack.func_77973_b() instanceof IPackageRecipeListItem;
            }
            case 10: {
                return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
            }
        }
        return stack.func_77973_b() instanceof IPackageItem;
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.updateRecipeList();
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new UnpackagerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int func_221476_a(int id) {
        if (id < 10) {
            return ((UnpackagerTile)this.tile).trackers[id].getSyncValue();
        }
        switch (id) {
            case 10: {
                return ((UnpackagerTile)this.tile).blocking ? 1 : 0;
            }
            case 11: {
                return ((UnpackagerTile)this.tile).trackerCount;
            }
            case 12: {
                return ((UnpackagerTile)this.tile).getEnergyStorage().getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_221477_a(int id, int value) {
        if (id < 10) {
            ((UnpackagerTile)this.tile).trackers[id].setSyncValue(value);
        }
        switch (id) {
            case 10: {
                ((UnpackagerTile)this.tile).blocking = value != 0;
                break;
            }
            case 11: {
                ((UnpackagerTile)this.tile).trackerCount = value;
                break;
            }
            case 12: {
                ((UnpackagerTile)this.tile).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int func_221478_a() {
        return 13;
    }

    public void updateRecipeList() {
        ((UnpackagerTile)this.tile).recipeList.clear();
        ItemStack listStack = this.getStackInSlot(9);
        if (listStack.func_77973_b() instanceof IPackageRecipeListItem) {
            ((UnpackagerTile)this.tile).recipeList.addAll(((IPackageRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList());
        }
        if (((UnpackagerTile)this.tile).func_145831_w() != null && !((UnpackagerTile)this.tile).func_145831_w().field_72995_K) {
            ((UnpackagerTile)this.tile).postPatternChange();
        }
    }

    public void clearRejectedIndexes() {
        for (UnpackagerTile.PackageTracker tracker : ((UnpackagerTile)this.tile).trackers) {
            tracker.clearRejectedIndexes();
        }
    }
}

