/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.ISettingsClonerItem;
import thelm.packagedauto.api.SettingsClonerData;

public class SettingsClonerItem
extends Item
implements ISettingsClonerItem {
    public static final SettingsClonerItem INSTANCE = new SettingsClonerItem();

    protected SettingsClonerItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(PackagedAuto.ITEM_GROUP));
        this.setRegistryName("packagedauto:settings_cloner");
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISettingsCloneable) {
            ISettingsCloneable settable = (ISettingsCloneable)tile;
            String configName = settable.getConfigTypeName();
            if (player.func_225608_bj_()) {
                if (!world.field_72995_K) {
                    CompoundNBT dataTag = new CompoundNBT();
                    ISettingsCloneable.Result result = settable.saveConfig(dataTag, player);
                    if (result.type != ISettingsCloneable.ResultType.FAIL) {
                        CompoundNBT tag = stack.func_196082_o();
                        tag.func_74778_a("Type", configName);
                        tag.func_218657_a("Data", (INBT)dataTag);
                        tag.func_74778_a("Dimension", world.func_234923_W_().func_240901_a_().toString());
                        tag.func_74783_a("Position", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.saved"), Util.field_240973_b_);
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.not_saved", new Object[]{result.message}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            SettingsClonerData data = this.getData(stack);
            if (data != null) {
                if (!world.field_72995_K) {
                    if (configName.equals(data.type())) {
                        ISettingsCloneable.Result result = settable.loadConfig(data.data(), player);
                        switch (result.type) {
                            case SUCCESS: {
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.loaded"), Util.field_240973_b_);
                                break;
                            }
                            case PARTIAL: {
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.partial_loaded", new Object[]{result.message}), Util.field_240973_b_);
                                break;
                            }
                            case FAIL: {
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.not_loaded", new Object[]{result.message}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                            }
                        }
                    } else {
                        TranslationTextComponent errorMessage = new TranslationTextComponent("item.packagedauto.settings_cloner.incompatible");
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.not_loaded", new Object[]{errorMessage}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_225608_bj_() && this.hasData(playerIn.func_184586_b(handIn))) {
            ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
            CompoundNBT nbt = stack.func_77978_p();
            nbt.func_82580_o("Type");
            nbt.func_82580_o("Data");
            nbt.func_82580_o("Dimension");
            nbt.func_82580_o("Position");
            if (nbt.isEmpty()) {
                stack.func_77982_d(null);
            }
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.cleared"), Util.field_240973_b_);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        SettingsClonerData data = this.getData(stack);
        if (data != null) {
            TranslationTextComponent typeComponent = new TranslationTextComponent(data.type());
            tooltip.add((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.contents", new Object[]{typeComponent}));
            StringTextComponent dimComponent = new StringTextComponent(data.dimension().func_240901_a_().toString());
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.packagedauto.dimension", new Object[]{dimComponent}));
            IFormattableTextComponent posComponent = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{data.x(), data.y(), data.z()}));
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.packagedauto.position", new Object[]{posComponent}));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public SettingsClonerData getData(ItemStack stack) {
        if (this.hasData(stack)) {
            CompoundNBT nbt = stack.func_77978_p();
            String type = nbt.func_74779_i("Type");
            CompoundNBT data = nbt.func_74775_l("Data");
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("Dimension")));
            int[] posArray = nbt.func_74759_k("Position");
            BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            return new SettingsClonerData(type, data, (RegistryKey<World>)dimension, blockPos);
        }
        return null;
    }

    public boolean hasData(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b("Type") && nbt.func_74764_b("Data") && nbt.func_74764_b("Dimension") && nbt.func_74764_b("Position");
    }
}

