/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.PacketHandler;

public class BeamPacket {
    private final Vector3d source;
    private final List<Vector3d> deltas;
    private final int color;
    private final int lifetime;
    private final boolean fadeout;

    public BeamPacket(Vector3d source, List<Vector3d> deltas, int color, int lifetime, boolean fadeout) {
        this.source = source;
        this.deltas = deltas;
        this.color = color;
        this.lifetime = lifetime;
        this.fadeout = fadeout;
    }

    public void encode(PacketBuffer buf) {
        buf.writeDouble(this.source.field_72450_a);
        buf.writeDouble(this.source.field_72448_b);
        buf.writeDouble(this.source.field_72449_c);
        buf.writeByte(this.deltas.size());
        for (Vector3d delta : this.deltas) {
            buf.writeDouble(delta.field_72450_a);
            buf.writeDouble(delta.field_72448_b);
            buf.writeDouble(delta.field_72449_c);
        }
        buf.writeMedium(this.color);
        buf.writeShort(this.lifetime);
        buf.writeBoolean(this.fadeout);
    }

    public static BeamPacket decode(PacketBuffer buf) {
        Vector3d source = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        int size = buf.readByte();
        ArrayList<Vector3d> deltas = new ArrayList<Vector3d>(size);
        for (int i = 0; i < size; ++i) {
            deltas.add(new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
        return new BeamPacket(source, deltas, buf.readUnsignedMedium(), buf.readUnsignedShort(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> WorldOverlayRenderer.INSTANCE.addBeams(this.source, this.deltas, this.color, this.lifetime, this.fadeout));
        ctx.get().setPacketHandled(true);
    }

    public static void sendBeams(Vector3d source, List<Vector3d> deltas, int color, int lifetime, boolean fadeout, RegistryKey<World> dimension, double range) {
        PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(source.field_72450_a, source.field_72448_b, source.field_72449_c, range, dimension)), (Object)new BeamPacket(source, deltas, color, lifetime, fadeout));
    }

    public static void sendBeams(ServerPlayerEntity player, Vector3d source, List<Vector3d> deltas, int color, int lifetime, boolean fadeout) {
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BeamPacket(source, deltas, color, lifetime, fadeout));
    }
}

