/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.PacketHandler;

public class DirectionalMarkerPacket {
    private final List<DirectionalGlobalPos> positions;
    private final int color;
    private final int lifetime;

    public DirectionalMarkerPacket(List<DirectionalGlobalPos> positions, int color, int lifetime) {
        this.positions = positions;
        this.color = color;
        this.lifetime = lifetime;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte(this.positions.size());
        for (DirectionalGlobalPos globalPos : this.positions) {
            buf.func_192572_a(globalPos.dimension().func_240901_a_());
            buf.writeInt(globalPos.x());
            buf.writeInt(globalPos.y());
            buf.writeInt(globalPos.z());
            buf.writeByte(globalPos.direction().func_176745_a());
        }
        buf.writeMedium(this.color);
        buf.writeShort(this.lifetime);
    }

    public static DirectionalMarkerPacket decode(PacketBuffer buf) {
        int size = buf.readByte();
        ArrayList<DirectionalGlobalPos> positions = new ArrayList<DirectionalGlobalPos>(size);
        for (int i = 0; i < size; ++i) {
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
            BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            Direction direction = Direction.func_82600_a((int)buf.readByte());
            positions.add(new DirectionalGlobalPos((RegistryKey<World>)dimension, pos, direction));
        }
        return new DirectionalMarkerPacket(positions, buf.readUnsignedMedium(), buf.readUnsignedShort());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> WorldOverlayRenderer.INSTANCE.addDirectionalMarkers(this.positions, this.color, this.lifetime));
        ctx.get().setPacketHandled(true);
    }

    public static void sendDirectionalMarkers(ServerPlayerEntity player, List<DirectionalGlobalPos> positions, int color, int lifetime) {
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new DirectionalMarkerPacket(positions, color, lifetime));
    }
}

