/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.MiscHelper;

public class SetItemStackPacket {
    private final int containerSlot;
    private final ItemStack stack;

    public SetItemStackPacket(int containerSlot, ItemStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public void encode(PacketBuffer buf) {
        buf.writeShort(this.containerSlot);
        MiscHelper.INSTANCE.writeItemWithLargeCount(buf, this.stack);
    }

    public static SetItemStackPacket decode(PacketBuffer buf) {
        return new SetItemStackPacket(buf.readUnsignedShort(), MiscHelper.INSTANCE.readItemWithLargeCount(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            Slot slot;
            Container container = player.field_71070_bA;
            if (container != null && this.containerSlot >= 0 && this.containerSlot < container.field_75151_b.size() && (slot = container.func_75139_a(this.containerSlot)) instanceof FalseCopySlot) {
                ItemStackHandler handler = (ItemStackHandler)((FalseCopySlot)slot).getItemHandler();
                handler.setStackInSlot(slot.getSlotIndex(), this.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

