/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.tile.BaseTile;

public class SyncEnergyPacket {
    private final BlockPos pos;
    private final int energy;

    public SyncEnergyPacket(BlockPos pos, int energy) {
        this.pos = pos;
        this.energy = energy;
    }

    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.energy);
    }

    public static SyncEnergyPacket decode(PacketBuffer buf) {
        return new SyncEnergyPacket(buf.func_179259_c(), buf.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world.func_195588_v(this.pos) && (te = world.func_175625_s(this.pos)) instanceof BaseTile) {
                ((BaseTile)te).getEnergyStorage().setEnergyStored(this.energy);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void syncEnergy(BlockPos pos, int energy, RegistryKey<World> dimension, double range) {
        PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range, dimension)), (Object)new SyncEnergyPacket(pos, energy));
    }
}

