/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.recipe.PositionedProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class PositionedProcessingPackageRecipeInfo
implements IPositionedProcessingPackageRecipeInfo {
    List<ItemStack> input = new ArrayList<ItemStack>();
    Int2ObjectMap<ItemStack> matrix = new Int2ObjectArrayMap(81);
    List<ItemStack> output = new ArrayList<ItemStack>();
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void read(CompoundNBT nbt) {
        int i;
        this.input.clear();
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Matrix", 10), matrixList);
        for (i = 0; i < 81 && i < matrixList.size(); ++i) {
            ItemStack stack = (ItemStack)matrixList.get(i);
            if (stack.func_190926_b()) continue;
            this.matrix.put(i, (Object)stack);
            this.input.add(stack);
        }
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Output", 10), this.output);
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            matrixList.add((ItemStack)this.matrix.getOrDefault(i, (Object)ItemStack.field_190927_a));
        }
        ListNBT matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), matrixList);
        nbt.func_218657_a("Matrix", (INBT)matrixTag);
        ListNBT outputTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.output);
        nbt.func_218657_a("Output", (INBT)outputTag);
        return nbt;
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return PositionedProcessingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public Int2ObjectMap<ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        int i;
        this.input.clear();
        for (i = 0; i < 81; ++i) {
            ItemStack stack = input.get(i).func_77946_l();
            if (stack.func_190926_b()) continue;
            this.matrix.put(i, (Object)stack);
            this.input.add(stack);
        }
        this.output.clear();
        this.output.addAll(MiscHelper.INSTANCE.condenseStacks(output, true));
        this.patterns.clear();
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i, true));
            ++i;
        }
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        map.putAll(this.matrix);
        for (int i = 0; i < this.output.size() && i < 3; ++i) {
            map.put(i * 3 + 82, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PositionedProcessingPackageRecipeInfo) {
            PositionedProcessingPackageRecipeInfo other = (PositionedProcessingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, null, other, null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, null);
    }
}

