/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.ProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class ProcessingPackageRecipeInfo
implements IPackageRecipeInfo {
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> output = new ArrayList<ItemStack>();
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void read(CompoundNBT nbt) {
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Input", 10), this.input);
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Output", 10), this.output);
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        ListNBT inputTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.input);
        nbt.func_218657_a("Input", (INBT)inputTag);
        ListNBT outputTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.output);
        nbt.func_218657_a("Output", (INBT)outputTag);
        return nbt;
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return ProcessingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.input.clear();
        this.input.addAll(MiscHelper.INSTANCE.condenseStacks(input));
        this.output.clear();
        this.output.addAll(MiscHelper.INSTANCE.condenseStacks(output));
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (i = 0; i < this.input.size(); ++i) {
            map.put(i, (Object)this.input.get(i));
        }
        for (i = 0; i < this.output.size() && i < 3; ++i) {
            map.put(i * 3 + 82, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProcessingPackageRecipeInfo) {
            ProcessingPackageRecipeInfo other = (ProcessingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, null, other, null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, null);
    }
}

