/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;

public abstract class BaseTile
extends TileEntity
implements INamedContainerProvider,
INameable {
    protected BaseItemHandler<?> itemHandler = new BaseItemHandler<BaseTile>(this, 0);
    protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
    public ITextComponent customName = null;
    protected UUID ownerUUID = null;
    @Deprecated
    protected int placerID = -1;

    public BaseTile(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public BaseItemHandler<?> getItemHandler() {
        return this.itemHandler;
    }

    public void setItemHandler(BaseItemHandler<?> itemHandler) {
        this.itemHandler = itemHandler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public void setOwner(PlayerEntity owner) {
        this.ownerUUID = owner.func_110124_au();
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    protected abstract ITextComponent getDefaultName();

    public int getComparatorSignal() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.itemHandler.getWrapperForDirection(null));
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.ownerUUID = null;
        if (nbt.func_186855_b("OwnerUUID")) {
            this.ownerUUID = nbt.func_186857_a("OwnerUUID");
        }
        this.readSync(nbt);
        this.itemHandler.read(nbt);
        this.energyStorage.read(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.ownerUUID != null) {
            nbt.func_186854_a("OwnerUUID", this.ownerUUID);
        }
        this.writeSync(nbt);
        this.itemHandler.write(nbt);
        this.energyStorage.write(nbt);
        return nbt;
    }

    public void readSync(CompoundNBT nbt) {
        if (nbt.func_74764_b("Name")) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("Name"));
        }
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        if (this.customName != null) {
            nbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSync(pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -10, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.readSync(tag);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_82580_o("ForgeData");
        nbt.func_82580_o("ForgeCaps");
        this.writeSync(nbt);
        return nbt;
    }

    public void syncTile(boolean rerender) {
        if (this.field_145850_b != null && this.field_145850_b.func_195588_v(this.field_174879_c)) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2 + (rerender ? 4 : 0));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemHandler.getWrapperForDirection(direction));
        }
        if (capability == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0) {
            return LazyOptional.of(() -> this.energyStorage);
        }
        return super.getCapability(capability, direction);
    }
}

