/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.CraftingProxyBlock;
import thelm.packagedauto.container.CraftingProxyContainer;
import thelm.packagedauto.integration.appeng.tile.AECraftingProxyTile;
import thelm.packagedauto.inventory.CraftingProxyItemHandler;
import thelm.packagedauto.item.ProxyMarkerItem;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.util.MiscHelper;

public class CraftingProxyTile
extends BaseTile
implements IPackageCraftingMachine,
ISettingsCloneable {
    public static final TileEntityType<CraftingProxyTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AECraftingProxyTile::new, () -> CraftingProxyTile::new), (Block[])new Block[]{CraftingProxyBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedauto:crafting_proxy");
    public static int range = 8;
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    public DirectionalGlobalPos target;

    public CraftingProxyTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new CraftingProxyItemHandler(this));
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedauto.crafting_proxy");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.crafting_proxy";
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        IPackageCraftingMachine machine;
        if (!this.isBusy() && (machine = (IPackageCraftingMachine)this.field_145850_b.func_175625_s(this.target.blockPos())).acceptPackage(recipeInfo, stacks, this.target.direction())) {
            Direction dir = this.target.direction();
            Vector3d source = Vector3d.func_237489_a_((Vector3i)this.field_174879_c);
            Vector3d delta = Vector3d.func_237491_b_((Vector3i)this.target.blockPos().func_177973_b((Vector3i)this.field_174879_c)).func_178787_e(Vector3d.func_237491_b_((Vector3i)dir.func_176730_m()).func_186678_a(0.5));
            BeamPacket.sendBeams(source, Collections.singletonList(delta), 0xFF7F00, 6, true, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), 32.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.target == null) {
            return true;
        }
        BlockPos pos = this.target.blockPos();
        if (!this.field_145850_b.func_195588_v(pos)) {
            return true;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile != null && !(tile instanceof CraftingProxyTile) && tile instanceof IPackageCraftingMachine) {
            return ((IPackageCraftingMachine)tile).isBusy();
        }
        return true;
    }

    public void sendPreview(ServerPlayerEntity player) {
        long currentTime = this.field_145850_b.func_82737_E();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.func_110124_au());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            if (this.target != null) {
                Direction dir = this.target.direction();
                Vector3d source = Vector3d.func_237489_a_((Vector3i)this.field_174879_c);
                Vector3d delta = Vector3d.func_237491_b_((Vector3i)this.target.blockPos().func_177973_b((Vector3i)this.field_174879_c)).func_178787_e(Vector3d.func_237491_b_((Vector3i)dir.func_176730_m()).func_186678_a(0.5));
                DirectionalMarkerPacket.sendDirectionalMarkers(player, Collections.singletonList(this.target), 0xFFFF00, 200);
                BeamPacket.sendBeams(player, source, Collections.singletonList(delta), 0xFFFF00, 200, false);
            }
            Vector3d lowerCorner = Vector3d.func_237491_b_((Vector3i)this.field_174879_c).func_178786_a((double)range, (double)range, (double)range);
            Vector3d size = new Vector3d((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 0xFF7F00, 200);
        }
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundNBT nbt, PlayerEntity player) {
        ItemStack stack;
        PlayerInventory playerInventory;
        block12: {
            if (!nbt.func_74764_b("Target")) {
                return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.invalid"));
            }
            int availableCount = 0;
            playerInventory = player.field_71071_by;
            if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
                if (this.itemHandler.getStackInSlot(0).func_77973_b() == ProxyMarkerItem.INSTANCE) {
                    availableCount += this.itemHandler.getStackInSlot(0).func_190916_E();
                } else {
                    return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("block.packagedauto.crafting_proxy.non_marker_present"));
                }
            }
            if (availableCount < 1) {
                for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                    stack = playerInventory.func_70301_a(i);
                    if (!stack.func_190926_b() && stack.func_77973_b() == ProxyMarkerItem.INSTANCE && !stack.func_77942_o()) {
                        availableCount += stack.func_190916_E();
                    }
                    if (availableCount < 1) {
                        continue;
                    }
                    break block12;
                }
                return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("block.packagedauto.crafting_proxy.no_markers"));
            }
        }
        int removedCount = this.itemHandler.getStackInSlot(0).func_190916_E();
        this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
        if (removedCount < 1) {
            for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                ItemStack stack2 = playerInventory.func_70301_a(i);
                if (!stack2.func_190926_b() && stack2.func_77973_b() == ProxyMarkerItem.INSTANCE && !stack2.func_77942_o()) {
                    removedCount += stack2.func_77979_a(1).func_190916_E();
                }
                if (removedCount >= 1) break;
            }
        }
        if (removedCount > 1 && !playerInventory.func_70441_a(stack = new ItemStack((IItemProvider)ProxyMarkerItem.INSTANCE, removedCount - 1))) {
            ItemEntity item = new ItemEntity(this.field_145850_b, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
            item.func_200216_c(player.func_110124_au());
            this.field_145850_b.func_217376_c((Entity)item);
        }
        CompoundNBT targetTag = nbt.func_74775_l("Target");
        RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(targetTag.func_74779_i("Dimension")));
        int[] posArray = targetTag.func_74759_k("Position");
        BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        Direction direction = Direction.func_82600_a((int)targetTag.func_74771_c("Direction"));
        DirectionalGlobalPos globalPos = new DirectionalGlobalPos((RegistryKey<World>)dimension, blockPos, direction);
        ItemStack stack3 = new ItemStack((IItemProvider)ProxyMarkerItem.INSTANCE);
        ProxyMarkerItem.INSTANCE.setDirectionalGlobalPos(stack3, globalPos);
        this.itemHandler.setStackInSlot(0, stack3);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundNBT nbt, PlayerEntity player) {
        if (this.target == null) {
            return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("block.packagedauto.crafting_proxy.empty"));
        }
        CompoundNBT targetTag = new CompoundNBT();
        targetTag.func_74778_a("Dimension", this.target.dimension().func_240901_a_().toString());
        targetTag.func_74783_a("Position", new int[]{this.target.x(), this.target.y(), this.target.z()});
        targetTag.func_74774_a("Direction", (byte)this.target.direction().func_176745_a());
        nbt.func_218657_a("Target", (INBT)targetTag);
        return ISettingsCloneable.Result.success();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new CraftingProxyContainer(windowId, playerInventory, this);
    }
}

