/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.container.UnpackagerContainer;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.tile.AEUnpackagerTile;
import thelm.packagedauto.inventory.UnpackagerItemHandler;
import thelm.packagedauto.item.RecipeHolderItem;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.tile.PackagerExtensionTile;
import thelm.packagedauto.tile.PackagerTile;
import thelm.packagedauto.util.MiscHelper;

public class UnpackagerTile
extends BaseTile
implements ITickableTileEntity,
ISettingsCloneable {
    public static final TileEntityType<UnpackagerTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AEUnpackagerTile::new, () -> UnpackagerTile::new), (Block[])new Block[]{UnpackagerBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedauto:unpackager");
    public static int energyCapacity = 5000;
    public static int energyUsage = 50;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public final PackageTracker[] trackers = new PackageTracker[10];
    public List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
    public boolean powered = false;
    public boolean blocking = false;
    public int trackerCount = 6;
    public int roundRobinIndex = 0;

    public UnpackagerTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new UnpackagerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i] = new PackageTracker();
        }
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedauto.unpackager");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.unpackager";
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                this.postPatternChange();
            }
            this.updatePowered();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
                this.fillTrackers();
                this.emptyTrackers();
            }
        }
    }

    protected void fillTrackers() {
        List emptyTrackers = Arrays.stream(this.trackers).limit(this.trackerCount).filter(t -> t.isEmpty()).collect(Collectors.toList());
        List nonEmptyTrackers = Arrays.stream(this.trackers).filter(t -> !t.isEmpty()).filter(t -> !t.isFilled()).collect(Collectors.toList());
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            if (this.energyStorage.getEnergyStored() < energyUsage || (stack = this.itemHandler.getStackInSlot(i)).func_190926_b() || !(stack.func_77973_b() instanceof IPackageItem)) continue;
            IPackageItem packageItem = (IPackageItem)stack.func_77973_b();
            boolean flag = false;
            for (PackageTracker tracker : nonEmptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    flag = true;
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    break;
                }
                tracker.setRejectedIndex(i, true);
            }
            if (flag) continue;
            for (PackageTracker tracker : emptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    continue block0;
                }
                tracker.setRejectedIndex(i, true);
            }
        }
    }

    protected void emptyTrackers() {
        TileEntity tile;
        ArrayList directions = Lists.newArrayList((Object[])Direction.values());
        Collections.rotate(directions, this.roundRobinIndex);
        block0: for (Direction direction : directions) {
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (!(tile instanceof IPackageCraftingMachine)) continue;
            IPackageCraftingMachine machine = (IPackageCraftingMachine)tile;
            for (PackageTracker tracker : this.trackers) {
                if (!tracker.isFilled() || tracker.recipe == null || !tracker.recipe.getRecipeType().hasMachine() || machine.isBusy() || !machine.acceptPackage(tracker.recipe, Lists.transform(tracker.recipe.getInputs(), ItemStack::func_77946_l), direction.func_176734_d())) continue;
                tracker.clearRecipe();
                this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                this.func_70296_d();
                continue block0;
            }
        }
        if (!this.powered) {
            directions = Lists.newArrayList((Object[])Direction.values());
            Collections.rotate(directions, this.roundRobinIndex);
            for (Direction direction : directions) {
                PackageTracker trackerToEmpty;
                tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                if (!this.validSendTarget(tile, direction.func_176734_d()) || !tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent()) continue;
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().get();
                if (this.blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler) || (trackerToEmpty = (PackageTracker)Arrays.stream(this.trackers).filter(t -> t.isFilled() && t.direction == null && t.recipe != null && !t.recipe.getRecipeType().hasMachine()).findFirst().orElse(null)) == null) continue;
                if (trackerToEmpty.toSend.isEmpty()) {
                    trackerToEmpty.setupToSend();
                }
                boolean acceptsAll = true;
                for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                    ItemStack stack = trackerToEmpty.toSend.get(i);
                    ItemStack stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, false, true);
                    acceptsAll &= stackRem.func_190916_E() < stack.func_190916_E();
                }
                trackerToEmpty.toSend.removeIf(ItemStack::func_190926_b);
                if (acceptsAll) {
                    trackerToEmpty.direction = direction;
                    this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                }
                this.func_70296_d();
            }
        }
        for (Direction direction : Direction.values()) {
            TileEntity tile2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            PackageTracker trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.direction == direction).findFirst().orElse(null);
            if (trackerToEmpty == null) continue;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.setupToSend();
            }
            boolean ordered = false;
            if (trackerToEmpty.recipe != null) {
                ordered = trackerToEmpty.recipe.getRecipeType().isOrdered();
            }
            if (!this.validSendTarget(tile2, direction.func_176734_d())) {
                trackerToEmpty.direction = null;
                continue;
            }
            if (!tile2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent()) {
                trackerToEmpty.direction = null;
                continue;
            }
            IItemHandler itemHandler = (IItemHandler)tile2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().get();
            for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                ItemStack stack = trackerToEmpty.toSend.get(i);
                ItemStack stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, ordered, false);
                trackerToEmpty.toSend.set(i, stackRem);
            }
            trackerToEmpty.toSend.removeIf(ItemStack::func_190926_b);
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.clearRecipe();
            }
            this.func_70296_d();
        }
    }

    protected boolean validSendTarget(TileEntity tile, Direction direction) {
        return tile != null && !(tile instanceof IPackageCraftingMachine) && !(tile instanceof PackagerTile) && !(tile instanceof PackagerExtensionTile) && !(tile instanceof UnpackagerTile);
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.func_70296_d();
        }
    }

    @Override
    public int getComparatorSignal() {
        return Math.min((int)Arrays.stream(this.trackers).filter(t -> t.isFilled()).count(), 15);
    }

    public void postPatternChange() {
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundNBT nbt, PlayerEntity player) {
        TranslationTextComponent message;
        block5: {
            this.blocking = nbt.func_74767_n("Blocking");
            this.trackerCount = nbt.func_74771_c("Trackers");
            message = null;
            if (nbt.func_74764_b("Recipes")) {
                if (this.itemHandler.getStackInSlot(9).func_190926_b()) {
                    PlayerInventory playerInventory = player.field_71071_by;
                    for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                        ItemStack stack = playerInventory.func_70301_a(i);
                        if (stack.func_190926_b() || stack.func_77973_b() != RecipeHolderItem.INSTANCE || stack.func_77942_o()) continue;
                        ItemStack stackCopy = stack.func_77979_a(1);
                        IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stackCopy);
                        List<IPackageRecipeInfo> recipeList = MiscHelper.INSTANCE.readRecipeList(nbt.func_150295_c("Recipes", 10));
                        recipeListObj.setRecipeList(recipeList);
                        RecipeHolderItem.INSTANCE.setRecipeList(stackCopy, recipeListObj);
                        this.itemHandler.setStackInSlot(9, stackCopy);
                        break block5;
                    }
                    message = new TranslationTextComponent("block.packagedauto.unpackager.no_holders");
                } else {
                    message = new TranslationTextComponent("block.packagedauto.unpackager.holder_present");
                }
            }
        }
        if (message != null) {
            return ISettingsCloneable.Result.partial(message);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundNBT nbt, PlayerEntity player) {
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74774_a("Trackers", (byte)this.trackerCount);
        if (!this.recipeList.isEmpty()) {
            nbt.func_218657_a("Recipes", (INBT)MiscHelper.INSTANCE.writeRecipeList(new ListNBT(), this.recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.blocking = nbt.func_74767_n("Blocking");
        this.trackerCount = nbt.func_74764_b("Trackers") ? (int)nbt.func_74771_c("Trackers") : 6;
        this.powered = nbt.func_74767_n("Powered");
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i].read(nbt.func_74775_l(String.format("Tracker%02d", i)));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74774_a("Trackers", (byte)this.trackerCount);
        nbt.func_74757_a("Powered", this.powered);
        for (int i = 0; i < this.trackers.length; ++i) {
            CompoundNBT subNBT = new CompoundNBT();
            this.trackers[i].write(subNBT);
            nbt.func_218657_a(String.format("Tracker%02d", i), (INBT)subNBT);
        }
        return nbt;
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.func_70296_d();
    }

    public void changeTrackerCount(boolean decrease) {
        this.trackerCount = MathHelper.func_76125_a((int)(this.trackerCount + (decrease ? -1 : 1)), (int)1, (int)10);
        this.func_70296_d();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new UnpackagerContainer(windowId, playerInventory, this);
    }

    public class PackageTracker {
        public boolean[] rejectedIndexes = new boolean[9];
        public IPackageRecipeInfo recipe;
        public int amount;
        public BooleanList received = new BooleanArrayList(9);
        public List<ItemStack> toSend = new ArrayList<ItemStack>();
        public Direction direction;

        public void clearRecipe() {
            this.clearRejectedIndexes();
            this.recipe = null;
            this.amount = 0;
            this.received.clear();
            this.direction = null;
            if (UnpackagerTile.this.field_145850_b != null && !((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_72995_K) {
                UnpackagerTile.this.func_70296_d();
            }
        }

        public void fillRecipe(IPackageRecipeInfo recipe) {
            this.recipe = recipe;
            this.amount = recipe.getPatterns().size();
            this.received.clear();
            this.received.size(this.amount);
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, true);
            }
            if (UnpackagerTile.this.field_145850_b != null && !((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_72995_K) {
                UnpackagerTile.this.func_70296_d();
            }
        }

        public void ejectItems() {
            if (UnpackagerTile.this.field_145850_b != null && !this.isEmpty()) {
                if (!this.toSend.isEmpty()) {
                    for (ItemStack stack : this.toSend) {
                        if (stack.func_190926_b()) continue;
                        double dx = (double)(((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        double dy = (double)(((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
                        double dz = (double)(((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        ItemEntity itemEntity = new ItemEntity(UnpackagerTile.this.field_145850_b, (double)UnpackagerTile.this.field_174879_c.func_177958_n() + dx, (double)UnpackagerTile.this.field_174879_c.func_177956_o() + dy, (double)UnpackagerTile.this.field_174879_c.func_177952_p() + dz, stack);
                        itemEntity.func_174869_p();
                        UnpackagerTile.this.field_145850_b.func_217376_c((Entity)itemEntity);
                    }
                } else {
                    List<IPackagePattern> patterns = this.recipe.getPatterns();
                    for (int i = 0; i < this.received.size() && i < patterns.size(); ++i) {
                        if (!this.received.getBoolean(i)) continue;
                        double dx = (double)(((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        double dy = (double)(((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
                        double dz = (double)(((UnpackagerTile)UnpackagerTile.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        ItemEntity itemEntity = new ItemEntity(UnpackagerTile.this.field_145850_b, (double)UnpackagerTile.this.field_174879_c.func_177958_n() + dx, (double)UnpackagerTile.this.field_174879_c.func_177956_o() + dy, (double)UnpackagerTile.this.field_174879_c.func_177952_p() + dz, patterns.get(i).getOutput());
                        itemEntity.func_174869_p();
                        UnpackagerTile.this.field_145850_b.func_217376_c((Entity)itemEntity);
                    }
                }
                this.clearRecipe();
            }
        }

        public boolean tryAcceptPackage(IPackageItem packageItem, ItemStack stack, int invIndex) {
            if (this.rejectedIndexes[invIndex]) {
                return false;
            }
            IPackageRecipeInfo recipe = packageItem.getRecipeInfo(stack);
            int index = packageItem.getIndex(stack);
            if (recipe != null && recipe.isValid() && recipe.validPatternIndex(index)) {
                if (this.recipe == null) {
                    this.recipe = recipe;
                    this.amount = recipe.getPatterns().size();
                    this.received.size(this.amount);
                    this.received.set(index, true);
                    UnpackagerTile.this.func_70296_d();
                    return true;
                }
                if (this.recipe.equals(recipe) && !this.received.getBoolean(index)) {
                    this.received.set(index, true);
                    UnpackagerTile.this.func_70296_d();
                    return true;
                }
            }
            return false;
        }

        public void setRejectedIndex(int index, boolean rejected) {
            this.rejectedIndexes[index] = rejected;
        }

        public void clearRejectedIndexes() {
            Arrays.fill(this.rejectedIndexes, false);
        }

        public boolean isFilled() {
            if (!this.toSend.isEmpty()) {
                return true;
            }
            if (this.received.isEmpty()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.received.iterator();
            while (booleanListIterator.hasNext()) {
                boolean b = (Boolean)booleanListIterator.next();
                if (b) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.recipe == null || !this.recipe.isValid();
        }

        public void setupToSend() {
            if (this.isEmpty() || this.recipe.getRecipeType().hasMachine() || !this.toSend.isEmpty()) {
                return;
            }
            this.toSend.addAll(Lists.transform(this.recipe.getInputs(), ItemStack::func_77946_l));
        }

        public void read(CompoundNBT nbt) {
            this.clearRecipe();
            CompoundNBT tag = nbt.func_74775_l("Recipe");
            IPackageRecipeInfo recipe = MiscHelper.INSTANCE.readRecipe(tag);
            if (recipe != null) {
                this.recipe = recipe;
                this.amount = nbt.func_74771_c("Amount");
                this.received.size(this.amount);
                byte[] receivedArray = nbt.func_74770_j("Received");
                for (int i = 0; i < this.received.size(); ++i) {
                    this.received.set(i, receivedArray[i] != 0);
                }
            }
            MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("ToSend", 10), this.toSend);
            if (nbt.func_74764_b("Direction")) {
                this.direction = Direction.func_82600_a((int)nbt.func_74771_c("Direction"));
            }
        }

        public CompoundNBT write(CompoundNBT nbt) {
            if (this.recipe != null) {
                CompoundNBT tag = MiscHelper.INSTANCE.writeRecipe(new CompoundNBT(), this.recipe);
                nbt.func_218657_a("Recipe", (INBT)tag);
                nbt.func_74774_a("Amount", (byte)this.amount);
                byte[] receivedArray = new byte[this.received.size()];
                for (int i = 0; i < this.received.size(); ++i) {
                    receivedArray[i] = (byte)(this.received.getBoolean(i) ? 1 : 0);
                }
                nbt.func_74773_a("Received", receivedArray);
            }
            nbt.func_218657_a("ToSend", (INBT)MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.toSend));
            if (this.direction != null) {
                nbt.func_74774_a("Direction", (byte)this.direction.func_176745_a());
            }
            return nbt;
        }

        public int getSyncValue() {
            int val = 0;
            for (int i = 0; i < this.received.size(); ++i) {
                if (!this.received.getBoolean(i)) continue;
                val |= 1 << i;
            }
            val <<= 4;
            return val |= this.amount;
        }

        public void setSyncValue(int val) {
            this.amount = val & 0xF;
            this.received.size(this.amount);
            val >>>= 4;
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, (val >>> i & 1) != 0);
            }
        }
    }
}

