package thelm.packagedauto;

import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import thelm.packagedauto.client.event.ClientEventHandler;
import thelm.packagedauto.event.CommonEventHandler;
import thelm.packagedauto.item.PackageItem;

@Mod(PackagedAuto.MOD_ID)
public class PackagedAuto {

	public static final String MOD_ID = "packagedauto";
	public static final ItemGroup ITEM_GROUP = new ItemGroup("packagedauto") {
		@OnlyIn(Dist.CLIENT)
		@Override
		public ItemStack func_78016_d() {
			return new ItemStack(PackageItem.INSTANCE);
		}
	};

	public PackagedAuto() {
		CommonEventHandler.getInstance().onConstruct();
		DistExecutor.unsafeRunWhenOn(Dist.CLIENT, ()->()->{
			ClientEventHandler.getInstance().onConstruct();
		});
	}
}
