package thelm.packagedauto.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.DistributorTile;

public class DistributorBlock extends BaseBlock {

	public static final DistributorBlock INSTANCE = new DistributorBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties().func_200916_a(PackagedAuto.ITEM_GROUP)).setRegistryName("packagedauto:distributor");

	protected DistributorBlock() {
		super(AbstractBlock.Properties.func_200945_a(Material.field_151573_f).func_200948_a(15F, 25F).func_200947_a(SoundType.field_185852_e));
		setRegistryName("packagedauto:distributor");
	}

	@Override
	public DistributorTile createTileEntity(BlockState state, IBlockReader worldIn) {
		return DistributorTile.TYPE_INSTANCE.func_200968_a();
	}

	@Override
	public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult rayTraceResult) {
		if(playerIn.func_225608_bj_()) {
			TileEntity tileentity = worldIn.func_175625_s(pos);
			if(tileentity instanceof DistributorTile) {
				if(!worldIn.field_72995_K) {
					((DistributorTile)tileentity).sendPreview((ServerPlayerEntity)playerIn);
				}
				return ActionResultType.SUCCESS;
			}
		}
		return super.func_225533_a_(state, worldIn, pos, playerIn, hand, rayTraceResult);
	}

	@Override
	public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
		if(state.func_177230_c() != newState.func_177230_c()) {
			TileEntity tileentity = worldIn.func_175625_s(pos);
			if(tileentity instanceof DistributorTile) {
				for(Int2ObjectMap.Entry<ItemStack> entry : ((DistributorTile)tileentity).pending.int2ObjectEntrySet()) {
					InventoryHelper.func_180173_a(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entry.getValue());
				}
			}
		}
		super.func_196243_a(state, worldIn, pos, newState, isMoving);
	}
}
