package thelm.packagedauto.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.PackagerExtensionTile;

public class PackagerExtensionBlock extends BaseBlock {

	public static final PackagerExtensionBlock INSTANCE = new PackagerExtensionBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties().func_200916_a(PackagedAuto.ITEM_GROUP)).setRegistryName("packagedauto:packager_extension");

	protected PackagerExtensionBlock() {
		super(AbstractBlock.Properties.func_200945_a(Material.field_151573_f).func_200948_a(15F, 25F).func_200947_a(SoundType.field_185852_e));
		setRegistryName("packagedauto:packager_extension");
	}

	@Override
	public PackagerExtensionTile createTileEntity(BlockState state, IBlockReader worldIn) {
		return PackagerExtensionTile.TYPE_INSTANCE.func_200968_a();
	}

	@Override
	public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof PackagerExtensionTile) {
			((PackagerExtensionTile)tileentity).updatePowered();
		}
	}
}
