package thelm.packagedauto.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.UnpackagerTile;
import thelm.packagedauto.tile.UnpackagerTile.PackageTracker;

public class UnpackagerBlock extends BaseBlock {

	public static final UnpackagerBlock INSTANCE = new UnpackagerBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties().func_200916_a(PackagedAuto.ITEM_GROUP)).setRegistryName("packagedauto:unpackager");

	protected UnpackagerBlock() {
		super(AbstractBlock.Properties.func_200945_a(Material.field_151573_f).func_200948_a(15F, 25F).func_200947_a(SoundType.field_185852_e));
		setRegistryName("packagedauto:unpackager");
	}

	@Override
	public UnpackagerTile createTileEntity(BlockState state, IBlockReader worldIn) {
		return UnpackagerTile.TYPE_INSTANCE.func_200968_a();
	}

	@Override
	public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
		if(state.func_177230_c() != newState.func_177230_c()) {
			TileEntity tileentity = worldIn.func_175625_s(pos);
			if(tileentity instanceof UnpackagerTile) {
				for(PackageTracker tracker : ((UnpackagerTile)tileentity).trackers) {
					tracker.ejectItems();
				}
			}
		}
		super.func_196243_a(state, worldIn, pos, newState, isMoving);
	}

	@Override
	public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof UnpackagerTile) {
			((UnpackagerTile)tileentity).updatePowered();
		}
	}
}
