package thelm.packagedauto.client.screen;

import org.lwjgl.glfw.GLFW;

import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedauto.container.BaseContainer;

// Code from Refined Storage
public abstract class AmountSpecifyingScreen<C extends BaseContainer<?>> extends BaseScreen<C> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");

	private BaseScreen<?> parent;

	protected TextFieldWidget amountField;

	public AmountSpecifyingScreen(BaseScreen<?> parent, C container, PlayerInventory playerInventory, ITextComponent title) {
		super(container, playerInventory, title);
		field_146999_f = 172;
		field_147000_g = 99;
		this.parent = parent;
	}

	protected abstract int getDefaultAmount();

	protected abstract int getMaxAmount();

	protected abstract int[] getIncrements();

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	protected void func_231160_c_() {
		field_230710_m_.clear();
		super.func_231160_c_();

		func_230480_a_(new ButtonSet(field_147003_i+114, field_147009_r+22, new TranslationTextComponent("misc.packagedauto.set")));
		func_230480_a_(new ButtonCancel(field_147003_i+114, field_147009_r+22+24, new TranslationTextComponent("gui.cancel")));

		amountField = new TextFieldWidget(field_230712_o_, field_147003_i+9, field_147009_r+51, 63, field_230712_o_.field_78288_b, StringTextComponent.field_240750_d_);
		amountField.func_146185_a(false);
		amountField.func_146180_a(String.valueOf(getDefaultAmount()));
		amountField.func_146193_g(0xFFFFFF);
		amountField.func_200675_a(s->{
			if(s.isEmpty()) {
				return true;
			}
			try {
				int amount = Integer.parseInt(s);
				return amount >= 0 && amount <= getMaxAmount();
			}
			catch(NumberFormatException e) {
				return false;
			}
		});
		func_230480_a_(amountField);

		int[] increments = getIncrements();
		int xx = 7;
		for(int i = 0; i < 3; ++i) {
			int increment = increments[i];
			String text = "+" + increment;
			func_230480_a_(new ButtonIncrement(increment, field_147003_i+xx, field_147009_r+20, new StringTextComponent(text)));
			xx += 34;
		}
		xx = 7;
		for(int i = 0; i < 3; ++i) {
			int increment = increments[i];
			String text = "-" + increment;
			func_230480_a_(new ButtonIncrement(-increment, field_147003_i+xx, field_147009_r+field_147000_g-20-7, new StringTextComponent(text)));
			xx += 34;
		}
	}

	@Override
	protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
		super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
		amountField.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
	}

	@Override
	protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
		field_230712_o_.func_238421_b_(matrixStack, func_231171_q_().getString(), 7, 7, 0x404040);
	}

	@Override
	public boolean func_231046_a_(int key, int scanCode, int modifiers) {
		if(key == GLFW.GLFW_KEY_ESCAPE) {
			close();
			return true;
		}
		if((key == GLFW.GLFW_KEY_ENTER || key == GLFW.GLFW_KEY_KP_ENTER) && amountField.func_230999_j_()) {
			onOkButtonPressed(func_231173_s_());
			return true;
		}
		if(amountField.func_231046_a_(key, scanCode, modifiers)) {
			return true;
		}
		InputMappings.Input mouseKey = InputMappings.func_197954_a(key, scanCode);
		if(field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey) && amountField.func_230999_j_()) {
			return true;
		}
		return super.func_231046_a_(key, scanCode, modifiers);
	}

	protected void onIncrementButtonClicked(int increment) {
		int oldAmount = 0;
		try {
			oldAmount = Integer.parseInt(amountField.func_146179_b());
		}
		catch(NumberFormatException e) {
			// NO OP
		}
		int newAmount = MathHelper.func_76125_a(oldAmount+increment, 0, getMaxAmount());
		amountField.func_146180_a(String.valueOf(newAmount));
	}

	protected abstract void onOkButtonPressed(boolean shiftDown);

	public void close() {
		field_230706_i_.func_147108_a(parent);
	}

	public BaseScreen<?> getParent() {
		return parent;
	}

	class ButtonSet extends Widget {

		public ButtonSet(int x, int y, ITextComponent text) {
			super(x, y, 50, 20, text);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			onOkButtonPressed(func_231173_s_());
		}
	}

	class ButtonCancel extends Widget {

		public ButtonCancel(int x, int y, ITextComponent text) {
			super(x, y, 50, 20, text);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			close();
		}
	}

	class ButtonIncrement extends Widget {

		int increment;

		public ButtonIncrement(int increment, int x, int y, ITextComponent text) {
			super(x, y, 34, 20, text);
			this.increment = increment;
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			onIncrementButtonClicked(increment);
		}
	}
}
