package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import thelm.packagedauto.container.CrafterContainer;

public class CrafterScreen extends BaseScreen<CrafterContainer> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/crafter.png");

	public CrafterScreen(CrafterContainer container, PlayerInventory playerInventory, ITextComponent title) {
		super(container, playerInventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
		super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
		func_238474_b_(matrixStack, field_147003_i+102, field_147009_r+35, 176, 0, menu.tile.getScaledProgress(22), 16);
		int scaledEnergy = menu.tile.getScaledEnergy(40);
		func_238474_b_(matrixStack, field_147003_i+10, field_147009_r+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
		String s = menu.tile.func_145748_c_().getString();
		field_230712_o_.func_238421_b_(matrixStack, s, field_146999_f/2 - field_230712_o_.func_78256_a(s)/2, 6, 0x404040);
		field_230712_o_.func_238421_b_(matrixStack, menu.playerInventory.func_145748_c_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-field_147003_i >= 10 && mouseY-field_147009_r >= 10 && mouseX-field_147003_i <= 21 && mouseY-field_147009_r <= 49) {
			func_238652_a_(matrixStack, new StringTextComponent(menu.tile.getEnergyStorage().getEnergyStored()+" / "+menu.tile.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-field_147003_i, mouseY-field_147009_r);
		}
	}
}
