package thelm.packagedauto.client.screen;

import java.util.Arrays;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.container.EncoderContainer;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.CycleRecipeTypePacket;
import thelm.packagedauto.network.packet.LoadRecipeListPacket;
import thelm.packagedauto.network.packet.SaveRecipeListPacket;
import thelm.packagedauto.network.packet.SetPatternIndexPacket;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class EncoderScreen extends BaseScreen<EncoderContainer> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/encoder.png");

	public EncoderScreen(EncoderContainer container, PlayerInventory playerInventory, ITextComponent title) {
		super(container, playerInventory, title);
		field_146999_f = 258;
		field_147000_g = 314;
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_231160_c_() {
		field_230710_m_.clear();
		super.func_231160_c_();
		int patternSlots = menu.tile.patternItemHandlers.length;
		for(int i = 0; i < patternSlots; ++i) {
			func_230480_a_(new ButtonPatternSlot(i, field_147003_i+30+(i%10)*18, field_147009_r+(patternSlots > 10 ? 16 : 25)+(i/10)*18));
		}
		func_230480_a_(new ButtonRecipeType(true, field_147003_i+189, field_147009_r+74));
		func_230480_a_(new ButtonRecipeType(false, field_147003_i+225, field_147009_r+74));
		func_230480_a_(new ButtonSavePatterns(field_147003_i+215, field_147009_r+16));
		func_230480_a_(new ButtonLoadPatterns(field_147003_i+215, field_147009_r+34));
		func_230480_a_(new ButtonClearPatterns(field_147003_i+171, field_147009_r+56));
	}

	@Override
	protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
		super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		for(int i = 0; i < 9; ++i) {
			for(int j = 0; j < 9; ++j) {
				Vector3i color = recipeType.getSlotColor(i*9+j);
				RenderSystem.color4f(color.func_177958_n()/255F, color.func_177956_o()/255F, color.func_177952_p()/255F, 1F);
				func_238463_a_(matrixStack, field_147003_i+8+j*18, field_147009_r+57+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		for(int i = 0; i < 3; ++i) {
			for(int j = 0; j < 3; ++j) {
				Vector3i color = recipeType.getSlotColor(81+i*3+j);
				RenderSystem.color4f(color.func_177958_n()/255F, color.func_177956_o()/255F, color.func_177952_p()/255F, 1F);
				func_238463_a_(matrixStack, field_147003_i+198+j*18, field_147009_r+111+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		RenderSystem.color4f(1F, 1F, 1F, 1F);
	}

	@Override
	protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
		String s = menu.tile.func_145748_c_().getString();
		field_230712_o_.func_238421_b_(matrixStack, s, field_146999_f/2 - field_230712_o_.func_78256_a(s)/2, 6, 0x404040);
		field_230712_o_.func_238421_b_(matrixStack, menu.playerInventory.func_145748_c_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		String str = menu.patternItemHandler.recipeType.getShortDisplayName().getString();
		field_230712_o_.func_238421_b_(matrixStack, str, 212 - field_230712_o_.func_78256_a(str)/2, 64, 0x404040);
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		if(recipeType != null) {
			Object rep = recipeType.getRepresentation();
			if(rep instanceof TextureAtlasSprite) {
				RenderSystem.color4f(1F, 1F, 1F, 1F);
				field_230706_i_.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
				func_238470_a_(matrixStack, 204, 75, 0, 16, 16, (TextureAtlasSprite)rep);
			}
			if(rep instanceof ItemStack) {
				RenderHelper.func_227780_a_();
				RenderSystem.color4f(1F, 1F, 1F, 1F);
				field_230706_i_.func_175599_af().func_175042_a((ItemStack)rep, 204, 75);
				RenderHelper.func_74518_a();
			}
		}
		for(Widget button : field_230710_m_) {
			if(button.func_231047_b_(mouseX, mouseY)) {
				button.func_230443_a_(matrixStack, mouseX-field_147003_i, mouseY-field_147009_r);
				break;
			}
		}
	}

	@Override
	public int getItemAmountSpecificationLimit(Slot slot) {
		return slot.func_75211_c().func_77976_d();
	}

	class ButtonPatternSlot extends Widget {

		int id;

		ButtonPatternSlot(int id, int x, int y) {
			super(x, y, 18, 18, StringTextComponent.field_240750_d_);
			this.id = id;
		}

		@Override
		protected int func_230989_a_(boolean mouseOver) {
			if(menu.tile.patternIndex == id) {
				return 2;
			}
			return super.func_230989_a_(mouseOver);
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			for(int i = 81; i < 90; ++i) {
				ItemStack stack = menu.tile.patternItemHandlers[id].getStackInSlot(i);
				if(!stack.func_190926_b()) {
					RenderHelper.func_227780_a_();
					RenderSystem.color4f(1F, 1F, 1F, 1F);
					minecraft.func_175599_af().func_175042_a(stack, field_230690_l_+1, field_230691_m_+1);
					RenderHelper.func_74518_a();
					break;
				}
			}
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			func_238652_a_(matrixStack, new TranslationTextComponent("block.packagedauto.encoder.pattern_slot", String.format("%02d", id)), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new SetPatternIndexPacket(id));
			menu.tile.setPatternIndex(id);
			menu.setupSlots();
		}
	}

	class ButtonRecipeType extends Widget {

		final boolean prev;

		ButtonRecipeType(boolean prev, int x, int y) {
			super(x, y, 10, 18, StringTextComponent.field_240750_d_);
			this.prev = prev;
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			minecraft.func_110434_K().func_110577_a(BACKGROUND);
			func_238463_a_(matrixStack, field_230690_l_+1, field_230691_m_+1, prev ? 258 : 266, 48, 8, 16, 512, 512);
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			func_238652_a_(matrixStack, new TranslationTextComponent("block.packagedauto.encoder.recipe_type."+(prev ? "prev" : "next")), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new CycleRecipeTypePacket(prev));
			menu.patternItemHandler.cycleRecipeType(prev);
			menu.setupSlots();
		}
	}

	class ButtonSavePatterns extends Widget {

		ButtonSavePatterns(int x, int y) {
			super(x, y, 36, 18, StringTextComponent.field_240750_d_);
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			minecraft.func_110434_K().func_110577_a(BACKGROUND);
			func_238463_a_(matrixStack, field_230690_l_+1, field_230691_m_+1, 258, 16, 34, 16, 512, 512);
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			ITextComponent line0 = new TranslationTextComponent("block.packagedauto.encoder.save");
			ITextComponent line1 = new TranslationTextComponent("block.packagedauto.encoder.save.single").func_240699_a_(TextFormatting.GRAY);
			func_243308_b(matrixStack, Arrays.asList(line0, line1), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			boolean single = func_231173_s_();
			PacketHandler.INSTANCE.sendToServer(new SaveRecipeListPacket(single));
		}
	}

	class ButtonLoadPatterns extends Widget {

		ButtonLoadPatterns(int x, int y) {
			super(x, y, 36, 18, StringTextComponent.field_240750_d_);
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			minecraft.func_110434_K().func_110577_a(BACKGROUND);
			func_238463_a_(matrixStack, field_230690_l_+1, field_230691_m_+1, 258, 32, 34, 16, 512, 512);
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			ITextComponent line0 = new TranslationTextComponent("block.packagedauto.encoder.load");
			ITextComponent line1 = new TranslationTextComponent("block.packagedauto.encoder.load.single").func_240699_a_(TextFormatting.GRAY);
			func_243308_b(matrixStack, Arrays.asList(line0, line1), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			boolean single = func_231173_s_();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, false));
			menu.tile.loadRecipeList(single, false);
			menu.setupSlots();
		}
	}

	class ButtonClearPatterns extends Widget {

		ButtonClearPatterns(int x, int y) {
			super(x, y, 7, 7, StringTextComponent.field_240750_d_);
		}

		@Override
		public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			ITextComponent line0 = new TranslationTextComponent("block.packagedauto.encoder.clear");
			ITextComponent line1 = new TranslationTextComponent("block.packagedauto.encoder.clear.all").func_240699_a_(TextFormatting.GRAY);
			func_243308_b(matrixStack, Arrays.asList(line0, line1), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			boolean single = !func_231173_s_();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, true));
			menu.tile.loadRecipeList(single, true);
			menu.setupSlots();
		}
	}
}
