package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import thelm.packagedauto.container.PackagerContainer;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangePackagingPacket;

public class PackagerScreen extends BaseScreen<PackagerContainer> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/packager.png");

	public PackagerScreen(PackagerContainer container, PlayerInventory playerInventory, ITextComponent title) {
		super(container, playerInventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_231160_c_() {
		field_230710_m_.clear();
		super.func_231160_c_();
		func_230480_a_(new ButtonChangePackaging(field_147003_i+98, field_147009_r+16));
	}

	@Override
	protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
		super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
		func_238474_b_(matrixStack, field_147003_i+102, field_147009_r+53, 176, 0, menu.tile.getScaledProgress(22), 16);
		int scaledEnergy = menu.tile.getScaledEnergy(40);
		func_238474_b_(matrixStack, field_147003_i+10, field_147009_r+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
		String s = menu.tile.func_145748_c_().getString();
		field_230712_o_.func_238421_b_(matrixStack, s, field_146999_f/2 - field_230712_o_.func_78256_a(s)/2, 6, 0x404040);
		field_230712_o_.func_238421_b_(matrixStack, menu.playerInventory.func_145748_c_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-field_147003_i >= 10 && mouseY-field_147009_r >= 10 && mouseX-field_147003_i <= 21 && mouseY-field_147009_r <= 49) {
			func_238652_a_(matrixStack, new StringTextComponent(menu.tile.getEnergyStorage().getEnergyStored()+" / "+menu.tile.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-field_147003_i, mouseY-field_147009_r);
		}
		for(Widget button : field_230710_m_) {
			if(button.func_231047_b_(mouseX, mouseY)) {
				button.func_230443_a_(matrixStack, mouseX-field_147003_i, mouseY-field_147009_r);
				break;
			}
		}
	}

	class ButtonChangePackaging extends Widget {

		ButtonChangePackaging(int x, int y) {
			super(x, y, 16, 18, StringTextComponent.field_240750_d_);
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			minecraft.func_110434_K().func_110577_a(BACKGROUND);
			func_238474_b_(matrixStack, field_230690_l_+1, field_230691_m_+2, 176, 56+14*menu.tile.mode.ordinal(), 14, 14);
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			func_238652_a_(matrixStack, menu.tile.mode.getTooltip(), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(ChangePackagingPacket.INSTANCE);
		}
	}
}
