package thelm.packagedauto.client.screen;

import java.util.Arrays;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedauto.container.UnpackagerContainer;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangeBlockingPacket;
import thelm.packagedauto.network.packet.EjectTrackerPacket;
import thelm.packagedauto.network.packet.TrackerCountPacket;
import thelm.packagedauto.tile.UnpackagerTile.PackageTracker;

public class UnpackagerScreen extends BaseScreen<UnpackagerContainer> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/unpackager.png");

	public UnpackagerScreen(UnpackagerContainer container, PlayerInventory playerInventory, ITextComponent title) {
		super(container, playerInventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_231160_c_() {
		field_230710_m_.clear();
		super.func_231160_c_();
		func_230480_a_(new ButtonChangeBlocking(field_147003_i+98, field_147009_r+16));
		for(int i = 0; i < 10; ++i) {
			func_230480_a_(new ButtonTracker(i, field_147003_i+115, field_147009_r+16+6*i));
		}
		func_230480_a_(new ButtonTrackerCount(true, field_147003_i+98, field_147009_r+34));
		func_230480_a_(new ButtonTrackerCount(false, field_147003_i+106, field_147009_r+34));
	}

	@Override
	protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
		super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
		int scaledEnergy = menu.tile.getScaledEnergy(40);
		func_238474_b_(matrixStack, field_147003_i+10, field_147009_r+10+40-scaledEnergy, 176, 40-scaledEnergy, 12, scaledEnergy);
		for(int i = 0; i < menu.tile.trackers.length; ++i) {
			PackageTracker tracker = menu.tile.trackers[i];
			for(int j = 0; j < 9; ++j) {
				if(j < tracker.amount) {
					if(tracker.received.getBoolean(j)) {
						func_238474_b_(matrixStack, field_147003_i+115+6*j, field_147009_r+16+6*i, 176, 45, 6, 5);
					}
					else {
						func_238474_b_(matrixStack, field_147003_i+115+6*j, field_147009_r+16+6*i, 176, 40, 6, 5);
					}
				}
				else if(i < menu.tile.trackerCount) {
					func_238474_b_(matrixStack, field_147003_i+115+6*j, field_147009_r+16+6*i, 182, 45, 6, 5);
				}
				else {
					func_238474_b_(matrixStack, field_147003_i+115+6*j, field_147009_r+16+6*i, 182, 40, 6, 5);
				}
			}
		}
	}

	@Override
	protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
		String s = menu.tile.func_145748_c_().getString();
		field_230712_o_.func_238421_b_(matrixStack, s, field_146999_f/2 - field_230712_o_.func_78256_a(s)/2, 6, 0x404040);
		field_230712_o_.func_238421_b_(matrixStack, menu.playerInventory.func_145748_c_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-field_147003_i >= 10 && mouseY-field_147009_r >= 10 && mouseX-field_147003_i <= 21 && mouseY-field_147009_r <= 49) {
			func_238652_a_(matrixStack, new StringTextComponent(menu.tile.getEnergyStorage().getEnergyStored()+" / "+menu.tile.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-field_147003_i, mouseY-field_147009_r);
		}
		for(Widget button : field_230710_m_) {
			if(button.func_231047_b_(mouseX, mouseY)) {
				button.func_230443_a_(matrixStack, mouseX-field_147003_i, mouseY-field_147009_r);
				break;
			}
		}
	}

	class ButtonChangeBlocking extends Widget {

		public ButtonChangeBlocking(int x, int y) {
			super(x, y, 16, 18, StringTextComponent.field_240750_d_);
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			minecraft.func_110434_K().func_110577_a(BACKGROUND);
			func_238474_b_(matrixStack, field_230690_l_+1, field_230691_m_+2, 176, menu.tile.blocking ? 64 : 50, 14, 14);
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			func_238652_a_(matrixStack, new TranslationTextComponent("block.packagedauto.unpackager.blocking."+menu.tile.blocking), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(ChangeBlockingPacket.INSTANCE);
		}
	}

	class ButtonTracker extends Widget {

		final int id;

		ButtonTracker(int id, int x, int y) {
			super(x, y, 54, 5, StringTextComponent.field_240750_d_);
			this.id = id;
		}

		@Override
		public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			ITextComponent line0 = new TranslationTextComponent("block.packagedauto.unpackager.tracker", id);
			ITextComponent line1 = new TranslationTextComponent("block.packagedauto.unpackager.tracker.eject").func_240699_a_(TextFormatting.GRAY);
			func_243308_b(matrixStack, Arrays.asList(line0, line1), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			if(func_231173_s_()) {
				PacketHandler.INSTANCE.sendToServer(new EjectTrackerPacket(id));
			}
		}
	}

	class ButtonTrackerCount extends Widget {

		final boolean decrease;

		public ButtonTrackerCount(boolean decrease, int x, int y) {
			super(x, y, 8, 18, StringTextComponent.field_240750_d_);
			this.decrease = decrease;
		}

		@Override
		protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			minecraft.func_110434_K().func_110577_a(BACKGROUND);
			func_238474_b_(matrixStack, field_230690_l_+1, field_230691_m_+2, decrease ? 176 : 182, 78, 6, 14);
		}

		@Override
		public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
			func_238652_a_(matrixStack, new TranslationTextComponent("block.packagedauto.unpackager.tracker."+(decrease ? "decrease" : "increase")), mouseX, mouseY);
		}

		@Override
		public void func_230982_a_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new TrackerCountPacket(decrease));
		}
	}
}
