package thelm.packagedauto.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.OptionalIntReferenceHolder;

//Large portions of code are taken from CoFHCore
public class BaseContainer<T extends BaseTile> extends Container {

	public final T tile;
	public final PlayerInventory playerInventory;
	public final BaseItemHandler<?> itemHandler;

	public BaseContainer(ContainerType<?> containerType, int windowId, PlayerInventory playerInventory, T tile) {
		super(containerType, windowId);
		this.tile = tile;
		this.playerInventory = playerInventory;
		itemHandler = tile != null ? tile.getItemHandler() : new BaseItemHandler<>(null, 0);
		func_216961_a(itemHandler);
	}

	public int getPlayerInvX() {
		return 8;
	}

	public int getPlayerInvY() {
		return 84;
	}

	public void setupPlayerInventory() {
		int xOffset = getPlayerInvX();
		int yOffset = getPlayerInvY();
		for(int i = 0; i < 3; i++) {
			for(int j = 0; j < 9; j++) {
				func_75146_a(new Slot(playerInventory, j+i*9+9, xOffset+j*18, yOffset+i*18));
			}
		}
		for(int i = 0; i < 9; i++) {
			func_75146_a(new Slot(playerInventory, i, xOffset+i*18, yOffset+58));
		}
	}

	@Override
	protected void func_216961_a(IIntArray array) {
		for(int i = 0; i < array.func_221478_a(); ++i) {
			func_216958_a(OptionalIntReferenceHolder.of(array, i));
		}
	}

	public int getContainerSize() {
		return itemHandler.getSlots();
	}

	public boolean supportsShiftClick(PlayerEntity player, int slotIndex) {
		return true;
	}

	public boolean performMerge(PlayerEntity player, int slotIndex, ItemStack stack) {
		int invBase = getContainerSize();
		int invFull = field_75151_b.size();
		if(slotIndex < invBase) {
			return func_75135_a(stack, invBase, invFull, true);
		}
		return func_75135_a(stack, 0, invBase, false);
	}

	@Override
	public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
		if(!supportsShiftClick(player, slotIndex)) {
			return ItemStack.field_190927_a;
		}
		ItemStack stack = ItemStack.field_190927_a;
		Slot slot = field_75151_b.get(slotIndex);
		if(slot != null && slot.func_75216_d()) {
			ItemStack stackInSlot = slot.func_75211_c();
			stack = stackInSlot.func_77946_l();
			if(!performMerge(player, slotIndex, stackInSlot)) {
				return ItemStack.field_190927_a;
			}
			slot.func_75220_a(stackInSlot, stack);
			if(stackInSlot.func_190916_E() <= 0) {
				slot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				slot.func_75215_d(stackInSlot);
			}
			if(stackInSlot.func_190916_E() == stack.func_190916_E()) {
				return ItemStack.field_190927_a;
			}
			slot.func_190901_a(player, stackInSlot);
		}
		return stack;
	}

	@Override
	protected boolean func_75135_a(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
		boolean successful = false;
		int i = !ascending ? slotMin : slotMax - 1;
		int iterOrder = !ascending ? 1 : -1;
		Slot slot;
		ItemStack existingStack;
		if(stack.func_77985_e()) {
			while(stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
				slot = field_75151_b.get(i);
				if(slot instanceof FalseCopySlot) {
					i += iterOrder;
					continue;
				}
				existingStack = slot.func_75211_c();
				if(!existingStack.func_190926_b()) {
					int maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a());
					int rmv = Math.min(maxStack, stack.func_190916_E());
					if(slot.func_75214_a(MiscHelper.INSTANCE.cloneStack(stack, rmv)) && existingStack.func_77973_b().equals(stack.func_77973_b()) && ItemStack.func_77970_a(stack, existingStack)) {
						int existingSize = existingStack.func_190916_E() + stack.func_190916_E();
						if(existingSize <= maxStack) {
							stack.func_190920_e(0);
							existingStack.func_190920_e(existingSize);
							slot.func_75215_d(existingStack);
							successful = true;
						}
						else if(existingStack.func_190916_E() < maxStack) {
							stack.func_190918_g(maxStack - existingStack.func_190916_E());
							existingStack.func_190920_e(maxStack);
							slot.func_75215_d(existingStack);
							successful = true;
						}
					}
				}
				i += iterOrder;
			}
		}
		if(stack.func_190916_E() > 0) {
			i = !ascending ? slotMin : slotMax - 1;
			while(stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
				slot = field_75151_b.get(i);
				if(slot instanceof FalseCopySlot) {
					i += iterOrder;
					continue;
				}
				existingStack = slot.func_75211_c();
				if(existingStack.func_190926_b()) {
					int maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a());
					int rmv = Math.min(maxStack, stack.func_190916_E());
					if(slot.func_75214_a(MiscHelper.INSTANCE.cloneStack(stack, rmv))) {
						existingStack = stack.func_77979_a(rmv);
						slot.func_75215_d(existingStack);
						successful = true;
					}
				}
				i += iterOrder;
			}
		}
		return successful;
	}

	@Override
	public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, PlayerEntity player) {
		if(slotId >= 0) {
			Slot slot = field_75151_b.get(slotId);
			if(slot instanceof FalseCopySlot) {
				if(clickType == ClickType.QUICK_MOVE) {
					slot.func_75215_d(ItemStack.field_190927_a);
				}
				else {
					ItemStack toPut = player.field_71071_by.func_70445_o().func_77946_l();
					ItemStack stack = slot.func_75211_c().func_77946_l();
					switch(mouseButton) {
					case 0: {
						slot.func_75215_d(toPut);
						break;
					}
					case 1: {
						if(stack.func_190926_b()) {
							if(!toPut.func_190926_b()) {
								toPut.func_190920_e(1);
							}
							slot.func_75215_d(toPut);
						}
						else if(stack.func_77969_a(toPut) && ItemStack.func_77970_a(stack, toPut) && stack.func_190916_E() < stack.func_77976_d()) {
							stack.func_190917_f(1);
							slot.func_75215_d(stack);
						}
						else {
							stack.func_190918_g(1);
							slot.func_75215_d(stack);
						}
						break;
					}
					}
				}
				return player.field_71071_by.func_70445_o();
			}
		}
		return super.func_184996_a(slotId, mouseButton, clickType, player);
	}

	@Override
	public boolean func_75145_c(PlayerEntity player) {
		if(tile != null) {
			BlockPos pos = tile.func_174877_v();
			return tile.func_145831_w().func_175625_s(pos) == tile && tile.func_174877_v().func_218138_a(player.func_213303_ch(), true) <= 64;
		}
		return true;
	}
}
