package thelm.packagedauto.crafting;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.item.ProxyMarkerItem;

public class ProxyMarkerCloningRecipe extends SpecialRecipe {

	public static final IRecipeSerializer<ProxyMarkerCloningRecipe> SERIALIZER = (IRecipeSerializer<ProxyMarkerCloningRecipe>)
			new SpecialRecipeSerializer<>(ProxyMarkerCloningRecipe::new).setRegistryName("packagedauto:proxy_marker_cloning");

	public ProxyMarkerCloningRecipe(ResourceLocation id) {
		super(id);
	}

	@Override
	public IRecipeSerializer<?> func_199559_b() {
		return SERIALIZER;
	}

	@Override
	public boolean matches(CraftingInventory inv, World world) {
		DirectionalGlobalPos template = null;
		int count = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ProxyMarkerItem.INSTANCE) {
					if(template == null) {
						DirectionalGlobalPos globalPos = ProxyMarkerItem.INSTANCE.getDirectionalGlobalPos(stack);
						if(globalPos != null) {
							template = globalPos;
						}
					}
					++count;
				}
				else {
					return false;
				}
			}
		}
		return template != null && count > 0;
	}

	@Override
	public ItemStack assemble(CraftingInventory inv) {
		DirectionalGlobalPos template = null;
		boolean clearing = false;
		int count = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ProxyMarkerItem.INSTANCE) {
					DirectionalGlobalPos globalPos = ProxyMarkerItem.INSTANCE.getDirectionalGlobalPos(stack);
					if(globalPos != null) {
						if(template == null) {
							template = globalPos;
						}
						else {
							clearing = true;
						}
					}
					++count;
				}
				else {
					return ItemStack.field_190927_a;
				}
			}
		}
		if(template != null && count > 0) {
			ItemStack result = new ItemStack(ProxyMarkerItem.INSTANCE, count);
			if(!clearing && count > 1) {
				ProxyMarkerItem.INSTANCE.setDirectionalGlobalPos(result, template);
			}
			return result;
		}
		else {
			return ItemStack.field_190927_a;
		}
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return true;
	}
}
