package thelm.packagedauto.crafting;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.item.RecipeHolderItem;

public class RecipeHolderCloningRecipe extends SpecialRecipe {

	public static final IRecipeSerializer<RecipeHolderCloningRecipe> SERIALIZER = (IRecipeSerializer<RecipeHolderCloningRecipe>)
			new SpecialRecipeSerializer<>(RecipeHolderCloningRecipe::new).setRegistryName("packagedauto:recipe_holder_cloning");

	public RecipeHolderCloningRecipe(ResourceLocation id) {
		super(id);
	}

	@Override
	public IRecipeSerializer<?> func_199559_b() {
		return SERIALIZER;
	}

	@Override
	public boolean matches(CraftingInventory inv, World world) {
		IPackageRecipeList template = null;
		int count = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == RecipeHolderItem.INSTANCE) {
					if(template == null) {
						IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stack);
						if(!recipeListObj.getRecipeList().isEmpty()) {
							template = recipeListObj;
						}
					}
					++count;
				}
				else {
					return false;
				}
			}
		}
		return template != null && count > 0;
	}

	@Override
	public ItemStack assemble(CraftingInventory inv) {
		IPackageRecipeList template = null;
		boolean clearing = false;
		int count = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == RecipeHolderItem.INSTANCE) {
					IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stack);
					if(!recipeListObj.getRecipeList().isEmpty()) {
						if(template == null) {
							template = recipeListObj;
						}
						else {
							clearing = true;
						}
					}
					++count;
				}
				else {
					return ItemStack.field_190927_a;
				}
			}
		}
		if(template != null && count > 0) {
			ItemStack result = new ItemStack(RecipeHolderItem.INSTANCE, count);
			if(!clearing && count > 1) {
				RecipeHolderItem.INSTANCE.setRecipeList(result, template);
			}
			return result;
		}
		else {
			return ItemStack.field_190927_a;
		}
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return true;
	}
}
