package thelm.packagedauto.inventory;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.util.MiscHelper;

public class BaseItemHandler<T extends BaseTile> extends ItemStackHandler implements IIntArray {

	public final T tile;
	protected Map<Direction, IItemHandlerModifiable> wrapperMap = new IdentityHashMap<>(7);

	public BaseItemHandler(T tile, int size) {
		super(size);
		this.tile = tile;
	}

	public List<ItemStack> getStacks() {
		return Collections.unmodifiableList(stacks);
	}

	@Override
	protected void onContentsChanged(int slot) {
		tile.func_70296_d();
	}

	public void read(CompoundNBT nbt) {
		stacks.clear();
		MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Items", 10), stacks, "Slot");
	}

	public CompoundNBT write(CompoundNBT nbt) {
		nbt.func_218657_a("Items", MiscHelper.INSTANCE.saveAllItems(new ListNBT(), stacks, "Slot"));
		return nbt;
	}

	public void markDirty() {
		tile.func_70296_d();
	}

	public void syncTile(boolean rerender) {
		tile.syncTile(rerender);
	}

	public IItemHandlerModifiable getWrapperForDirection(Direction side) {
		return this;
	}

	@Override
	public int func_221476_a(int index) {
		return 0;
	}

	@Override
	public void func_221477_a(int index, int value) {}

	@Override
	public int func_221478_a() {
		return 0;
	}
}
