package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IProxyMarkerItem;
import thelm.packagedauto.tile.CraftingProxyTile;

public class CraftingProxyItemHandler extends BaseItemHandler<CraftingProxyTile> {

	public CraftingProxyItemHandler(CraftingProxyTile tile) {
		super(tile, 1);
	}

	@Override
	protected void onContentsChanged(int slot) {
		loadMarker();
		super.onContentsChanged(slot);
	}

	@Override
	public int getSlotLimit(int slot) {
		return 1;
	}

	@Override
	public boolean isItemValid(int slot, ItemStack stack) {
		return stack.func_77973_b() instanceof IProxyMarkerItem && ((IProxyMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
	}

	@Override
	public IItemHandlerModifiable getWrapperForDirection(Direction side) {
		return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
	}

	@Override
	public void read(CompoundNBT nbt) {
		super.read(nbt);
		loadMarker();
	}

	public void loadMarker() {
		ItemStack stack = getStackInSlot(0);
		if(stack.func_77973_b() instanceof IProxyMarkerItem) {
			DirectionalGlobalPos pos = ((IProxyMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
			if(pos == null) {
				tile.target = null;
			}
			else if(tile.func_145831_w() != null && !tile.func_145831_w().func_234923_W_().equals(pos.dimension())) {
				tile.target = null;
			}
			else {
				Vector3i dirVec = pos.blockPos().func_177973_b(tile.func_174877_v());
				int dist = Ints.max(Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p()));
				if(dist <= CraftingProxyTile.range) {
					tile.target = pos;
				}
			}
		}
		else {
			tile.target = null;
		}
	}
}
