package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.tile.DistributorTile;

public class DistributorItemHandler extends BaseItemHandler<DistributorTile> {

	public DistributorItemHandler(DistributorTile tile) {
		super(tile, 81);
	}

	@Override
	protected void onContentsChanged(int slot) {
		loadMarker(slot);
		super.onContentsChanged(slot);
	}

	@Override
	public int getSlotLimit(int slot) {
		return 1;
	}

	@Override
	public boolean isItemValid(int slot, ItemStack stack) {
		return stack.func_77973_b() instanceof IDistributorMarkerItem && ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
	}

	@Override
	public IItemHandlerModifiable getWrapperForDirection(Direction side) {
		return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
	}

	@Override
	public void read(CompoundNBT nbt) {
		super.read(nbt);
		for(int i = 0; i < 81; ++i) {
			loadMarker(i);
		}
	}

	public void loadMarker(int slot) {
		ItemStack stack = getStackInSlot(slot);
		if(stack.func_77973_b() instanceof IDistributorMarkerItem) {
			DirectionalGlobalPos pos = ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
			if(pos == null) {
				tile.positions.remove(slot);
			}
			else if(tile.func_145831_w() != null && !tile.func_145831_w().func_234923_W_().equals(pos.dimension())) {
				tile.positions.remove(slot);
			}
			else {
				Vector3i dirVec = pos.blockPos().func_177973_b(tile.func_174877_v());
				int dist = Ints.max(Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p()));
				if(dist <= DistributorTile.range) {
					tile.positions.put(slot, pos);
				}
			}
		}
		else {
			tile.positions.remove(slot);
		}
	}
}
