package thelm.packagedauto.item;

import java.util.List;

import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IMarkerItem;

public abstract class MarkerItem extends Item implements IMarkerItem {

	public MarkerItem(Item.Properties properties) {
		super(properties);
	}

	@Override
	public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
		World world = context.func_195991_k();
		PlayerEntity player = context.func_195999_j();
		if(!world.field_72995_K && !player.func_225608_bj_()) {
			if(getDirectionalGlobalPos(stack) != null) {
				return super.onItemUseFirst(stack, context);
			}
			RegistryKey<World> dim = world.func_234923_W_();
			BlockPos pos = context.func_195995_a();
			Direction dir = context.func_196000_l();
			DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dim, pos, dir);
			if(stack.func_190916_E() > 1) {
				ItemStack stack1 = stack.func_77979_a(1);
				setDirectionalGlobalPos(stack1, globalPos);
				if(!player.field_71071_by.func_70441_a(stack1)) {
					ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack1);
					item.func_200216_c(player.func_110124_au());
					world.func_217376_c(item);
				}
			}
			else {
				setDirectionalGlobalPos(stack, globalPos);
			}
			return ActionResultType.SUCCESS;
		}
		return super.onItemUseFirst(stack, context);
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
		if(!worldIn.field_72995_K && playerIn.func_225608_bj_() && isBound(playerIn.func_184586_b(handIn))) {
			ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
			setDirectionalGlobalPos(stack, null);
			return ActionResult.func_226248_a_(stack);
		}
		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
		DirectionalGlobalPos pos = getDirectionalGlobalPos(stack);
		if(pos != null) {
			ITextComponent dimComponent = new StringTextComponent(pos.dimension().func_240901_a_().toString());
			tooltip.add(new TranslationTextComponent("misc.packagedauto.dimension", dimComponent));
			ITextComponent posComponent = TextComponentUtils.func_240647_a_(new TranslationTextComponent("chat.coordinates", pos.x(), pos.y(), pos.z()));
			tooltip.add(new TranslationTextComponent("misc.packagedauto.position", posComponent));
			ITextComponent dirComponent = new TranslationTextComponent("misc.packagedauto."+pos.direction().func_176742_j());
			tooltip.add(new TranslationTextComponent("misc.packagedauto.direction", dirComponent));
		}
		super.func_77624_a(stack, worldIn, tooltip, flagIn);
	}

	@Override
	public DirectionalGlobalPos getDirectionalGlobalPos(ItemStack stack) {
		if(isBound(stack)) {
			CompoundNBT nbt = stack.func_77978_p();
			RegistryKey<World> dimension = RegistryKey.func_240903_a_(Registry.field_239699_ae_, new ResourceLocation(nbt.func_74779_i("Dimension")));
			int[] posArray = nbt.func_74759_k("Position");
			BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
			Direction direction = Direction.func_82600_a(nbt.func_74771_c("Direction"));
			return new DirectionalGlobalPos(dimension, blockPos, direction);
		}
		return null;
	}

	@Override
	public void setDirectionalGlobalPos(ItemStack stack, DirectionalGlobalPos pos) {
		if(pos != null) {
			CompoundNBT nbt = stack.func_196082_o();
			nbt.func_74778_a("Dimension", pos.dimension().func_240901_a_().toString());
			nbt.func_74783_a("Position", new int[] {pos.x(), pos.y(), pos.z()});
			nbt.func_74774_a("Direction", (byte)pos.direction().func_176745_a());
		}
		else if(stack.func_77942_o()) {
			CompoundNBT nbt = stack.func_77978_p();
			nbt.func_82580_o("Dimension");
			nbt.func_82580_o("Position");
			nbt.func_82580_o("Direction");
			if(nbt.isEmpty()) {
				stack.func_77982_d(null);
			}
		}
	}

	public boolean isBound(ItemStack stack) {
		CompoundNBT nbt = stack.func_77978_p();
		return nbt != null && nbt.func_74764_b("Dimension") && nbt.func_74764_b("Position") && nbt.func_74764_b("Direction");
	}
}
