package thelm.packagedauto.tile;

import java.util.UUID;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;

public abstract class BaseTile extends TileEntity implements INamedContainerProvider, INameable {

	protected BaseItemHandler<?> itemHandler = new BaseItemHandler<>(this, 0);
	protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
	public ITextComponent customName = null;
	protected UUID ownerUUID = null;
	@Deprecated
	protected int placerID = -1;

	public BaseTile(TileEntityType<?> tileEntityType) {
		super(tileEntityType);
	}

	public BaseItemHandler<?> getItemHandler() {
		return itemHandler;
	}

	public void setItemHandler(BaseItemHandler<?> itemHandler) {
		this.itemHandler = itemHandler;
	}

	public EnergyStorage getEnergyStorage() {
		return energyStorage;
	}

	public void setEnergyStorage(EnergyStorage energyStorage) {
		this.energyStorage = energyStorage;
	}

	public void setOwner(PlayerEntity owner) {
		ownerUUID = owner.func_110124_au();
	}

	@Override
	public ITextComponent func_200200_C_() {
		return customName != null ? customName : getDefaultName();
	}

	@Override
	public ITextComponent func_145748_c_() {
		return func_200200_C_();
	}

	@Override
	public ITextComponent func_200201_e() {
		return customName;
	}

	public void setCustomName(ITextComponent name) {
		customName = name;
	}

	protected abstract ITextComponent getDefaultName();

	public int getComparatorSignal() {
		return ItemHandlerHelper.calcRedstoneFromInventory(itemHandler.getWrapperForDirection(null));
	}

	@Override
	public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
		super.func_230337_a_(blockState, nbt);
		ownerUUID = null;
		if(nbt.func_186855_b("OwnerUUID")) {
			ownerUUID = nbt.func_186857_a("OwnerUUID");
		}
		readSync(nbt);
		itemHandler.read(nbt);
		energyStorage.read(nbt);
	}

	@Override
	public CompoundNBT func_189515_b(CompoundNBT nbt) {
		super.func_189515_b(nbt);
		if(ownerUUID != null) {
			nbt.func_186854_a("OwnerUUID", ownerUUID);
		}
		writeSync(nbt);
		itemHandler.write(nbt);
		energyStorage.write(nbt);
		return nbt;
	}

	public void readSync(CompoundNBT nbt) {
		if(nbt.func_74764_b("Name")) {
			customName = ITextComponent.Serializer.func_240643_a_(nbt.func_74779_i("Name"));
		}
	}

	public CompoundNBT writeSync(CompoundNBT nbt) {
		if(customName != null) {
			nbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a(customName));
		}
		return nbt;
	}

	@Override
	public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
		readSync(pkt.func_148857_g());
	}

	@Override
	public SUpdateTileEntityPacket func_189518_D_() {
		return new SUpdateTileEntityPacket(field_174879_c, -10, func_189517_E_());
	}

	@Override
	public void handleUpdateTag(BlockState state, CompoundNBT tag) {
		readSync(tag);
	}

	@Override
	public CompoundNBT func_189517_E_() {
		CompoundNBT nbt = super.func_189517_E_();
		nbt.func_82580_o("ForgeData");
		nbt.func_82580_o("ForgeCaps");
		writeSync(nbt);
		return nbt;
	}

	public void syncTile(boolean rerender) {
		if(field_145850_b != null && field_145850_b.func_195588_v(field_174879_c)) {
			BlockState state = field_145850_b.func_180495_p(field_174879_c);
			field_145850_b.func_184138_a(field_174879_c, state, state, 2 + (rerender ? 4 : 0));
		}
	}

	@Override
	public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
		if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
			return LazyOptional.of(()->(T)itemHandler.getWrapperForDirection(direction));
		}
		else if(capability == CapabilityEnergy.ENERGY && energyStorage.getMaxEnergyStored() > 0) {
			return LazyOptional.of(()->(T)energyStorage);
		}
		return super.getCapability(capability, direction);
	}
}
