package thelm.packagedauto.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.container.DistributorContainer;
import thelm.packagedauto.integration.appeng.tile.AEDistributorTile;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class DistributorTile extends BaseTile implements ITickableTileEntity, IPackageCraftingMachine, ISettingsCloneable {

	public static final TileEntityType<DistributorTile> TYPE_INSTANCE = (TileEntityType<DistributorTile>)TileEntityType.Builder.
			func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(()->ModList.get().isLoaded("appliedenergistics2"),
					()->AEDistributorTile::new, ()->DistributorTile::new), DistributorBlock.INSTANCE).
			func_206865_a(null).setRegistryName("packagedauto:distributor");

	public static int range = 16;
	public static int refreshInterval = 4;

	public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap<>(81);
	public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap<>(81);
	public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60, TimeUnit.SECONDS).build();

	public DistributorTile() {
		super(TYPE_INSTANCE);
		setItemHandler(new DistributorItemHandler(this));
	}

	@Override
	protected ITextComponent getDefaultName() {
		return new TranslationTextComponent("block.packagedauto.distributor");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.distributor";
	}

	@Override
	public void func_73660_a() {
		if(!field_145850_b.field_72995_K) {
			if(field_145850_b.func_82737_E() % refreshInterval == 0 && !pending.isEmpty()) {
				distributeItems();
			}
		}
	}

	@Override
	public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
		if(!isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo) {
			IPositionedProcessingPackageRecipeInfo recipe = (IPositionedProcessingPackageRecipeInfo)recipeInfo;
			boolean blocking = false;
			TileEntity unpackager = field_145850_b.func_175625_s(field_174879_c.func_177972_a(direction));
			if(unpackager instanceof UnpackagerTile) {
				blocking = ((UnpackagerTile)unpackager).blocking;
			}
			Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
			if(!positions.keySet().containsAll(matrix.keySet())) {
				return false;
			}
			for(Int2ObjectMap.Entry<ItemStack> entry : matrix.int2ObjectEntrySet()) {
				BlockPos pos = positions.get(entry.getIntKey()).blockPos();
				if(!field_145850_b.func_195588_v(pos)) {
					return false;
				}
				TileEntity tile = field_145850_b.func_175625_s(pos);
				if(tile == null) {
					return false;
				}
				ItemStack stack = entry.getValue().func_77946_l();
				Direction dir = positions.get(entry.getIntKey()).direction();
				IItemHandler itemHandler = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).orElse(null);
				if(itemHandler != null) {
					if(blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
						return false;
					}
					if(!ItemHandlerHelper.insertItem(itemHandler, stack, true).func_190926_b()) {
						return false;
					}
				}
				else {
					return false;
				}
			}
			for(Int2ObjectMap.Entry<ItemStack> entry : matrix.int2ObjectEntrySet()) {
				pending.put(entry.getIntKey(), entry.getValue().func_77946_l());
			}
			distributeItems();
			return true;
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		return !pending.isEmpty();
	}

	protected void distributeItems() {
		List<Vector3d> deltas = new ArrayList<>();
		for(int i : pending.keySet().toIntArray()) {
			if(!positions.containsKey(i)) {
				ejectItems();
				break;
			}
			BlockPos pos = positions.get(i).blockPos();
			if(!field_145850_b.func_195588_v(pos)) {
				continue;
			}
			TileEntity tile = field_145850_b.func_175625_s(pos);
			if(tile == null) {
				ejectItems();
				break;
			}
			ItemStack stack = pending.get(i);
			Direction dir = positions.get(i).direction();
			IItemHandler itemHandler = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).orElse(null);
			ItemStack stackRem = stack;
			if(itemHandler != null) {
				stackRem = ItemHandlerHelper.insertItem(itemHandler, stack, false);
			}
			else {
				ejectItems();
				break;
			}
			if(stackRem.func_190916_E() < stack.func_190916_E()) {
				Vector3d delta = Vector3d.func_237491_b_(pos.func_177973_b(field_174879_c)).func_178787_e(Vector3d.func_237491_b_(dir.func_176730_m()).func_186678_a(0.5));
				deltas.add(delta);	
			}
			if(stackRem.func_190926_b()) {
				pending.remove(i);
			}
			else {
				pending.put(i, stackRem);
			}
		}
		if(!deltas.isEmpty()) {
			Vector3d source = Vector3d.func_237489_a_(field_174879_c);
			BeamPacket.sendBeams(source, deltas, 0x00FFFF, 6, true, field_145850_b.func_234923_W_(), 32);
			func_70296_d();
		}
	}

	protected void ejectItems() {
		for(int i = 0; i < 81; ++i) {
			if(pending.containsKey(i)) {
				ItemStack stack = pending.remove(i);
				if(!stack.func_190926_b()) {
					double dx = field_145850_b.field_73012_v.nextFloat()/2+0.25;
					double dy = field_145850_b.field_73012_v.nextFloat()/2+0.75;
					double dz = field_145850_b.field_73012_v.nextFloat()/2+0.25;
					ItemEntity itemEntity = new ItemEntity(field_145850_b, field_174879_c.func_177958_n()+dx, field_174879_c.func_177956_o()+dy, field_174879_c.func_177952_p()+dz, stack);
					itemEntity.func_174869_p();
					field_145850_b.func_217376_c(itemEntity);
				}
			}
		}
		func_70296_d();
	}

	public void sendPreview(ServerPlayerEntity player) {
		long currentTime = field_145850_b.func_82737_E();
		Long cachedTime = previewTimes.getIfPresent(player.func_110124_au());
		if(cachedTime == null || currentTime-cachedTime > 180) {
			previewTimes.put(player.func_110124_au(), currentTime);
			if(!positions.isEmpty()) {
				List<Vector3d> deltas = positions.values().stream().map(globalPos->{
					BlockPos pos = globalPos.blockPos();
					Direction dir = globalPos.direction();
					return Vector3d.func_237491_b_(pos.func_177973_b(field_174879_c)).func_72441_c(dir.func_82601_c()*0.5, dir.func_96559_d()*0.5, dir.func_82599_e()*0.5);
				}).collect(Collectors.toList());
				Vector3d source = Vector3d.func_237489_a_(field_174879_c);
				DirectionalMarkerPacket.sendDirectionalMarkers(player, new ArrayList<>(positions.values()), 0x00FF7F, 200);
				BeamPacket.sendBeams(player, source, deltas, 0x00FF7F, 200, false);
			}
			Vector3d lowerCorner = Vector3d.func_237491_b_(field_174879_c).func_178786_a(range, range, range);
			Vector3d size = new Vector3d(range*2+1, range*2+1, range*2+1);
			SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 0x00FFFF, 200);
		}
	}

	@Override
	public int getComparatorSignal() {
		if(!pending.isEmpty()) {
			return 15;
		}
		return 0;
	}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundNBT nbt, PlayerEntity player) {
		ListNBT positionsTag = nbt.func_150295_c("Positions", 10);
		if(positionsTag.isEmpty()) {
			return ISettingsCloneable.Result.fail(new TranslationTextComponent("item.packagedauto.settings_cloner.invalid"));
		}
		int requiredCount = positionsTag.size();
		int availableCount = 0;
		PlayerInventory playerInventory = player.field_71071_by;
		for(int i = 0; i < itemHandler.getSlots(); ++i) {
			ItemStack stack = itemHandler.getStackInSlot(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == DistributorMarkerItem.INSTANCE) {
					availableCount += stack.func_190916_E();
				}
				else {
					return ISettingsCloneable.Result.fail(new TranslationTextComponent("block.packagedauto.distributor.non_marker_present"));
				}
			}
		}
		f:if(availableCount < requiredCount) {
			for(int i = 0; i < playerInventory.func_70302_i_(); ++i) {
				ItemStack stack = playerInventory.func_70301_a(i);
				if(!stack.func_190926_b() && stack.func_77973_b() == DistributorMarkerItem.INSTANCE && !stack.func_77942_o()) {
					availableCount += stack.func_190916_E();
				}
				if(availableCount >= requiredCount) {
					break f;
				}
			}
			return ISettingsCloneable.Result.fail(new TranslationTextComponent("block.packagedauto.distributor.no_markers"));
		}
		int removedCount = 0;
		for(int i = 0; i < itemHandler.getSlots(); ++i) {
			removedCount += itemHandler.getStackInSlot(i).func_190916_E();
			itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
		}
		if(removedCount < requiredCount) {
			for(int i = 0; i < playerInventory.func_70302_i_(); ++i) {
				ItemStack stack = playerInventory.func_70301_a(i);
				if(!stack.func_190926_b() && stack.func_77973_b() == DistributorMarkerItem.INSTANCE && !stack.func_77942_o()) {
					removedCount += stack.func_77979_a(requiredCount - removedCount).func_190916_E();
				}
				if(removedCount >= requiredCount) {
					break;
				}
			}
		}
		if(removedCount > requiredCount) {
			ItemStack stack = new ItemStack(DistributorMarkerItem.INSTANCE, removedCount-requiredCount);
			if(!playerInventory.func_70441_a(stack)) {
				ItemEntity item = new ItemEntity(field_145850_b, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
				item.func_200216_c(player.func_110124_au());
				field_145850_b.func_217376_c(item);
			}
		}
		for(int i = 0; i < requiredCount; ++i) {
			CompoundNBT positionTag = positionsTag.func_150305_b(i);
			int index = positionTag.func_74771_c("Index");
			RegistryKey<World> dimension = RegistryKey.func_240903_a_(Registry.field_239699_ae_, new ResourceLocation(positionTag.func_74779_i("Dimension")));
			int[] posArray = positionTag.func_74759_k("Position");
			BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
			Direction direction = Direction.func_82600_a(positionTag.func_74771_c("Direction"));
			DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dimension, blockPos, direction);
			ItemStack stack = new ItemStack(DistributorMarkerItem.INSTANCE);
			DistributorMarkerItem.INSTANCE.setDirectionalGlobalPos(stack, globalPos);
			itemHandler.setStackInSlot(index, stack);
		}
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundNBT nbt, PlayerEntity player) {
		if(positions.isEmpty()) {
			return ISettingsCloneable.Result.fail(new TranslationTextComponent("block.packagedauto.distributor.empty"));
		}
		ListNBT positionsTag = new ListNBT();
		for(Int2ObjectMap.Entry<DirectionalGlobalPos> entry : positions.int2ObjectEntrySet()) {
			DirectionalGlobalPos pos = entry.getValue();
			CompoundNBT positionTag = new CompoundNBT();
			positionTag.func_74774_a("Index", (byte)entry.getIntKey());
			positionTag.func_74778_a("Dimension", pos.dimension().func_240901_a_().toString());
			positionTag.func_74783_a("Position", new int[] {pos.x(), pos.y(), pos.z()});
			positionTag.func_74774_a("Direction", (byte)pos.direction().func_176745_a());
			positionsTag.add(positionTag);
		}
		nbt.func_218657_a("Positions", positionsTag);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
		super.func_230337_a_(blockState, nbt);
		pending.clear();
		List<ItemStack> pendingList = new ArrayList<>();
		MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Pending", 10), pendingList);
		for(int i = 0; i < 81 && i < pendingList.size(); ++i) {
			ItemStack stack = pendingList.get(i);
			if(!stack.func_190926_b()) {
				pending.put(i, stack);
			}
		}
	}

	@Override
	public CompoundNBT func_189515_b(CompoundNBT nbt) {
		super.func_189515_b(nbt);
		List<ItemStack> pendingList = new ArrayList<>();
		for(int i = 0; i < 81; ++i) {
			pendingList.add(pending.getOrDefault(i, ItemStack.field_190927_a));
		}
		ListNBT pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), pendingList);
		nbt.func_218657_a("Pending", pendingTag);
		return nbt;
	}

	@Override
	public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
		syncTile(false);
		return new DistributorContainer(windowId, playerInventory, this);
	}
}
