package thelm.packagedauto.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagerExtensionBlock;
import thelm.packagedauto.container.PackagerExtensionContainer;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.tile.AEPackagerExtensionTile;
import thelm.packagedauto.inventory.PackagerExtensionItemHandler;
import thelm.packagedauto.util.MiscHelper;

public class PackagerExtensionTile extends BaseTile implements ITickableTileEntity, ISettingsCloneable {

	public static final TileEntityType<PackagerExtensionTile> TYPE_INSTANCE = (TileEntityType<PackagerExtensionTile>)TileEntityType.Builder.
			func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(()->ModList.get().isLoaded("appliedenergistics2"),
					()->AEPackagerExtensionTile::new, ()->PackagerExtensionTile::new), PackagerExtensionBlock.INSTANCE).
			func_206865_a(null).setRegistryName("packagedauto:packager_extension");

	public static int energyCapacity = 5000;
	public static int energyReq = 500;
	public static int energyUsage = 100;
	public static int refreshInterval = 4;
	public static boolean drawMEEnergy = true;

	public boolean firstTick = true;
	public boolean isWorking = false;
	public int remainingProgress = 0;
	public PackagerTile packager;
	public IItemHandlerModifiable listStackItemHandler = new ItemStackHandler(1);
	public List<IPackagePattern> patternList = new ArrayList<>();
	public IPackagePattern currentPattern;
	public boolean lockPattern = false;
	public PackagerTile.Mode mode = PackagerTile.Mode.EXACT;
	public boolean disjoint = false;
	public boolean powered = false;

	public PackagerExtensionTile() {
		super(TYPE_INSTANCE);
		setItemHandler(new PackagerExtensionItemHandler(this));
		setEnergyStorage(new EnergyStorage(this, energyCapacity));
	}

	@Override
	protected ITextComponent getDefaultName() {
		return new TranslationTextComponent("block.packagedauto.packager_extension");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.packager";
	}

	@Override
	public void func_73660_a() {
		if(firstTick) {
			firstTick = false;
			updatePatternList();
			updatePowered();
		}
		if(!field_145850_b.field_72995_K) {
			if(isWorking) {
				tickProcess();
				if(remainingProgress <= 0 && isInputValid()) {
					finishProcess();
					if(!itemHandler.getStackInSlot(9).func_190926_b()) {
						ejectItem();
					}
					if(!canStart()) {
						endProcess();
					}
					else {
						startProcess();
					}
				}
			}
			else if(field_145850_b.func_82737_E() % refreshInterval == 0) {
				if(canStart()) {
					startProcess();
					tickProcess();
					isWorking = true;
				}
			}
			chargeEnergy();
			if(field_145850_b.func_82737_E() % refreshInterval == 0) {
				if(!itemHandler.getStackInSlot(9).func_190926_b()) {
					ejectItem();
				}
			}
		}
	}

	public boolean isInputValid() {
		if(currentPattern == null) {
			getPattern();
		}
		if(currentPattern == null) {
			return false;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.func_190926_b()).collect(Collectors.toList());
		if(input.isEmpty()) {
			return false;
		}
		if(!lockPattern && disjoint) {
			return MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), true);
		}
		List<Ingredient> matchers = Lists.transform(currentPattern.getInputs(), PackagerTile::getIngredient);
		int[] matches = RecipeMatcher.findMatches(input, matchers);
		if(matches == null) {
			return false;
		}
		for(int i = 0; i < matches.length; ++i) {
			if(input.get(i).func_190916_E() < currentPattern.getInputs().get(matches[i]).func_190916_E()) {
				return false;
			}
		}
		return true;
	}

	protected boolean canStart() {
		getPattern();
		if(currentPattern == null) {
			return false;
		}
		if(!isInputValid()) {
			return false;
		}
		ItemStack slotStack = itemHandler.getStackInSlot(9);
		ItemStack outputStack = currentPattern.getOutput();
		return slotStack.func_190926_b() || slotStack.func_77969_a(outputStack) && ItemStack.func_77970_a(slotStack, outputStack) && slotStack.func_190916_E()+1 <= outputStack.func_77976_d();
	}

	protected boolean canFinish() {
		return remainingProgress <= 0 && isInputValid();
	}

	protected void getPattern() {
		if(currentPattern != null && lockPattern) {
			return;
		}
		lockPattern = false;
		currentPattern = null;
		if(powered) {
			return;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.func_190926_b()).collect(Collectors.toList());
		if(input.isEmpty()) {
			return;
		}
		for(IPackagePattern pattern : patternList) {
			if(disjoint) {
				if(MiscHelper.INSTANCE.removeExactSet(input, pattern.getInputs(), true)) {
					currentPattern = pattern;
					return;
				}
			}
			else {
				List<Ingredient> matchers = Lists.transform(pattern.getInputs(), PackagerTile::getIngredient);
				int[] matches = RecipeMatcher.findMatches(input, matchers);
				if(matches != null) {
					currentPattern = pattern;
					return;
				}
			}
		}
	}

	public void updatePatternList() {
		packager = null;
		listStackItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
		patternList.clear();
		if(field_145850_b != null) {
			for(BlockPos posP : BlockPos.func_218278_a(field_174879_c.func_177982_a(-1, -1, -1), field_174879_c.func_177982_a(1, 1, 1))) {
				TileEntity te = field_145850_b.func_175625_s(posP);
				if(te instanceof PackagerTile) {
					packager = (PackagerTile)te;
					ItemStack listStack = packager.itemHandler.getStackInSlot(10);
					listStackItemHandler.setStackInSlot(0, listStack);
					patternList.addAll(packager.patternList);
					switch(mode) {
					case EXACT:
						disjoint = false;
						break;
					case DISJOINT:
						disjoint = MiscHelper.INSTANCE.arePatternsDisjoint(patternList);
						break;
					case FIRST:
						disjoint = true;
						break;
					}
					break;
				}
			}
		}
	}

	protected void tickProcess() {
		int energy = energyStorage.extractEnergy(Math.min(energyUsage, remainingProgress), false);
		remainingProgress -= energy;
	}

	protected void finishProcess() {
		if(currentPattern == null) {
			getPattern();
		}
		if(currentPattern == null) {
			endProcess();
			return;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.func_190926_b()).collect(Collectors.toList());
		if(input.isEmpty()) {
			endProcess();
			return;
		}
		if(!lockPattern && disjoint) {
			if(!MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), true)) {
				endProcess();
				return;
			}
			if(itemHandler.getStackInSlot(9).func_190926_b()) {
				itemHandler.setStackInSlot(9, currentPattern.getOutput());
			}
			else if(itemHandler.getStackInSlot(9).func_77973_b() instanceof IPackageItem) {
				itemHandler.getStackInSlot(9).func_190917_f(1);
			}
			else {
				endProcess();
				return;
			}
			MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), false);
		}
		else {
			List<Ingredient> matchers = Lists.transform(currentPattern.getInputs(), PackagerTile::getIngredient);
			int[] matches = RecipeMatcher.findMatches(input, matchers);
			if(matches == null) {
				endProcess();
				return;
			}
			if(itemHandler.getStackInSlot(9).func_190926_b()) {
				itemHandler.setStackInSlot(9, currentPattern.getOutput());
			}
			else if(itemHandler.getStackInSlot(9).func_77973_b() instanceof IPackageItem) {
				itemHandler.getStackInSlot(9).func_190917_f(1);
			}
			else {
				endProcess();
				return;
			}
			for(int i = 0; i < matches.length; ++i) {
				input.get(i).func_190918_g(currentPattern.getInputs().get(matches[i]).func_190916_E());
			}
		}
		for(int i = 0; i < 9; ++i) {
			if(itemHandler.getStackInSlot(i).func_190926_b()) {
				itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
			}
		}
	}

	protected void startProcess() {
		remainingProgress = energyReq;
		func_70296_d();
	}

	public void endProcess() {
		remainingProgress = 0;
		isWorking = false;
		lockPattern = false;
		func_70296_d();
	}

	protected void ejectItem() {
		for(Direction direction : Direction.values()) {
			TileEntity te = field_145850_b.func_175625_s(field_174879_c.func_177972_a(direction));
			if(te instanceof UnpackagerTile) {
				UnpackagerTile tile = (UnpackagerTile)te;
				ItemStack stack = itemHandler.getStackInSlot(9);
				if(!stack.func_190926_b()) {
					ItemStack stackRem = ItemHandlerHelper.insertItem(tile.itemHandler, stack, false);
					itemHandler.setStackInSlot(9, stackRem);
				}
			}
		}
	}

	protected void chargeEnergy() {
		ItemStack energyStack = itemHandler.getStackInSlot(10);
		if(energyStack.getCapability(CapabilityEnergy.ENERGY, null).isPresent()) {
			int energyRequest = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
			energyStorage.receiveEnergy(energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get().extractEnergy(energyRequest, false), false);
			if(energyStack.func_190916_E() <= 0) {
				itemHandler.setStackInSlot(10, ItemStack.field_190927_a);
			}
		}
	}

	public void updatePowered() {
		if(field_145850_b.func_175687_A(field_174879_c) > 0 != powered) {
			powered = !powered;
			func_70296_d();
		}
	}

	@Override
	public int getComparatorSignal() {
		if(isWorking) {
			return 1;
		}
		if(!itemHandler.getStackInSlot(9).func_190926_b()) {
			return 15;
		}
		return 0;
	}

	public boolean canPushPattern() {
		return !isWorking && itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
	}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundNBT nbt, PlayerEntity player) {
		mode = PackagerTile.Mode.values()[nbt.func_74771_c("Mode")];
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundNBT nbt, PlayerEntity player) {
		nbt.func_74774_a("Mode", (byte)mode.ordinal());
		ItemStack listStack = listStackItemHandler.getStackInSlot(0);
		if(listStack.func_77973_b() instanceof IPackageRecipeListItem) {
			List<IPackageRecipeInfo> recipeList = ((IPackageRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList();
			if(!recipeList.isEmpty()) {
				nbt.func_218657_a("Recipes", MiscHelper.INSTANCE.writeRecipeList(new ListNBT(), recipeList));
			}
		}
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
		mode = PackagerTile.Mode.values()[nbt.func_74771_c("Mode")];
		super.func_230337_a_(blockState, nbt);
		updatePatternList();
		isWorking = nbt.func_74767_n("Working");
		remainingProgress = nbt.func_74762_e("Progress");
		powered = nbt.func_74767_n("Powered");
		lockPattern = false;
		currentPattern = null;
		if(nbt.func_74764_b("Pattern")) {
			CompoundNBT tag = nbt.func_74775_l("Pattern");
			IPackageRecipeInfo recipe = MiscHelper.INSTANCE.readRecipe(tag);
			if(recipe != null) {
				List<IPackagePattern> patterns = recipe.getPatterns();
				byte index = tag.func_74771_c("Index");
				if(index >= 0 && index < patterns.size()) {
					currentPattern = patterns.get(index);
					lockPattern = true;
				}
			}
		}
	}

	@Override
	public CompoundNBT func_189515_b(CompoundNBT nbt) {
		super.func_189515_b(nbt);
		nbt.func_74774_a("Mode", (byte)mode.ordinal());
		nbt.func_74757_a("Working", isWorking);
		nbt.func_74768_a("Progress", remainingProgress);
		nbt.func_74757_a("Powered", powered);
		if(lockPattern) {
			CompoundNBT tag = MiscHelper.INSTANCE.writeRecipe(new CompoundNBT(), currentPattern.getRecipeInfo());
			tag.func_74774_a("Index", (byte)currentPattern.getIndex());
			nbt.func_218657_a("Pattern", tag);
		}
		return nbt;
	}

	public void changePackagingMode() {
		mode = PackagerTile.Mode.values()[((mode.ordinal()+1) % 3)];
		updatePatternList();
		func_70296_d();
	}

	@Override
	public void func_70296_d() {
		if(isWorking && !isInputValid()) {
			endProcess();
		}
		super.func_70296_d();
	}

	public int getScaledEnergy(int scale) {
		if(energyStorage.getMaxEnergyStored() <= 0) {
			return 0;
		}
		return Math.min(scale * energyStorage.getEnergyStored() / energyStorage.getMaxEnergyStored(), scale);
	}

	public int getScaledProgress(int scale) {
		if(remainingProgress <= 0 || energyReq <= 0) {
			return 0;
		}
		return scale * (energyReq-remainingProgress) / energyReq;
	}

	@Override
	public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
		syncTile(false);
		return new PackagerExtensionContainer(windowId, playerInventory, this);
	}
}
