package thelm.packagedauto.util;

import java.util.OptionalInt;

import net.minecraft.util.IIntArray;
import net.minecraft.util.IntReferenceHolder;

public abstract class OptionalIntReferenceHolder extends IntReferenceHolder {

	private OptionalInt prevValue = OptionalInt.empty();

	public static OptionalIntReferenceHolder of(IIntArray data, final int id) {
		return new OptionalIntReferenceHolder() {
			@Override
			public int func_221495_b() {
				return data.func_221476_a(id);
			}
			@Override
			public void func_221494_a(int pValue) {
				data.func_221477_a(id, pValue);
			}
		};
	}

	public static OptionalIntReferenceHolder of(int[] data, final int id) {
		return new OptionalIntReferenceHolder() {
			@Override
			public int func_221495_b() {
				return data[id];
			}
			@Override
			public void func_221494_a(int value) {
				data[id] = value;
			}
		};
	}

	public static OptionalIntReferenceHolder of() {
		return new OptionalIntReferenceHolder() {
			private int value;
			@Override
			public int func_221495_b() {
				return value;
			}
			@Override
			public void func_221494_a(int value) {
				this.value = value;
			}
		};
	}

	@Override
	public boolean func_221496_c() {
		int i = func_221495_b();
		boolean flag = !prevValue.isPresent() || i != prevValue.getAsInt();
		prevValue = OptionalInt.of(i);
		return flag;
	}
}
