/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;

public abstract class BaseBlockEntity
extends BlockEntity
implements Nameable,
MenuProvider {
    protected BaseItemHandler<?> itemHandler = new BaseItemHandler<BaseBlockEntity>(this, 0);
    protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
    public Component customName = null;
    protected UUID ownerUUID = null;
    @Deprecated
    protected int placerID = -1;

    public BaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public BaseItemHandler<?> getItemHandler() {
        return this.itemHandler;
    }

    public void setItemHandler(BaseItemHandler<?> itemHandler) {
        this.itemHandler = itemHandler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public void setOwner(Player owner) {
        this.ownerUUID = owner.m_142081_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    protected abstract Component getDefaultName();

    public void tick() {
    }

    public int getComparatorSignal() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.itemHandler.getWrapperForDirection(null));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ownerUUID = null;
        if (nbt.m_128403_("OwnerUUID")) {
            this.ownerUUID = nbt.m_128342_("OwnerUUID");
        }
        this.loadSync(nbt);
        this.itemHandler.load(nbt);
        this.energyStorage.read(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.ownerUUID != null) {
            nbt.m_128362_("OwnerUUID", this.ownerUUID);
        }
        this.saveSync(nbt);
        this.itemHandler.save(nbt);
        this.energyStorage.save(nbt);
    }

    public void loadSync(CompoundTag nbt) {
        if (nbt.m_128441_("Name")) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("Name"));
        }
    }

    public CompoundTag saveSync(CompoundTag nbt) {
        if (this.customName != null) {
            nbt.m_128359_("Name", Component.Serializer.m_130703_((Component)this.customName));
        }
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.loadSync(pkt.m_131708_());
        }
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.loadSync(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128473_("ForgeData");
        nbt.m_128473_("ForgeCaps");
        this.saveSync(nbt);
        return nbt;
    }

    public void sync(boolean rerender) {
        if (this.f_58857_ != null && this.f_58857_.m_46749_(this.f_58858_)) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 2 + (rerender ? 4 : 0));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemHandler.getWrapperForDirection(direction));
        }
        if (capability == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0) {
            return LazyOptional.of(() -> this.energyStorage);
        }
        return super.getCapability(capability, direction);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity baseBlockEntity = (BaseBlockEntity)blockEntity;
            baseBlockEntity.tick();
        }
    }
}

